/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.ComboBoxBase;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.ListBox;
import de.matthiasmann.twl.ListBoxDisplay;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.IntegerModel;
import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.model.ListSelectionModel;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Font;
import de.matthiasmann.twl.utils.CallbackSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBox<T>
extends ComboBoxBase {
    public static final AnimationState.StateKey STATE_ERROR = AnimationState.StateKey.get("error");
    private static final int INVALID_WIDTH = -1;
    private final ComboboxLabel label = new ComboboxLabel(this.getAnimationState());
    private final ListBox<T> listbox = new ComboboxListbox();
    private Runnable[] selectionChangedListeners;
    private ListModel.ChangeListener modelChangeListener;
    String displayTextNoSelection = "";
    boolean noSelectionIsError;
    boolean computeWidthFromModel;
    int modelWidth = -1;

    public ComboBox(ListSelectionModel<T> model) {
        this();
        this.setModel(model);
    }

    public ComboBox(ListModel<T> model, IntegerModel selectionModel) {
        this();
        this.setModel(model);
        this.setSelectionModel(selectionModel);
    }

    public ComboBox(ListModel<T> model) {
        this();
        this.setModel(model);
    }

    public ComboBox() {
        this.button.getModel().addStateCallback(new Runnable(){

            public void run() {
                ComboBox.this.updateHover();
            }
        });
        this.label.addCallback(new CallbackWithReason<Label.CallbackReason>(){

            @Override
            public void callback(Label.CallbackReason reason) {
                ComboBox.this.openPopup();
            }
        });
        this.listbox.addCallback(new CallbackWithReason<ListBox.CallbackReason>(){

            @Override
            public void callback(ListBox.CallbackReason reason) {
                switch (reason) {
                    case KEYBOARD_RETURN: 
                    case MOUSE_CLICK: 
                    case MOUSE_DOUBLE_CLICK: {
                        ComboBox.this.listBoxSelectionChanged(true);
                        break;
                    }
                    default: {
                        ComboBox.this.listBoxSelectionChanged(false);
                    }
                }
            }
        });
        this.popup.setTheme("comboboxPopup");
        this.popup.add(this.listbox);
        this.add(this.label);
    }

    public void addCallback(Runnable cb) {
        this.selectionChangedListeners = CallbackSupport.addCallbackToList(this.selectionChangedListeners, cb, Runnable.class);
    }

    public void removeCallback(Runnable cb) {
        this.selectionChangedListeners = CallbackSupport.removeCallbackFromList(this.selectionChangedListeners, cb);
    }

    private void doCallback() {
        CallbackSupport.fireCallbacks(this.selectionChangedListeners);
    }

    public void setModel(ListModel<T> model) {
        this.unregisterModelChangeListener();
        this.listbox.setModel(model);
        if (this.computeWidthFromModel) {
            this.registerModelChangeListener();
        }
    }

    public ListModel<T> getModel() {
        return this.listbox.getModel();
    }

    public void setSelectionModel(IntegerModel selectionModel) {
        this.listbox.setSelectionModel(selectionModel);
    }

    public IntegerModel getSelectionModel() {
        return this.listbox.getSelectionModel();
    }

    public void setModel(ListSelectionModel<T> model) {
        this.listbox.setModel(model);
    }

    public void setSelected(int selected) {
        this.listbox.setSelected(selected);
        this.updateLabel();
    }

    public int getSelected() {
        return this.listbox.getSelected();
    }

    public boolean isComputeWidthFromModel() {
        return this.computeWidthFromModel;
    }

    public void setComputeWidthFromModel(boolean computeWidthFromModel) {
        if (this.computeWidthFromModel != computeWidthFromModel) {
            this.computeWidthFromModel = computeWidthFromModel;
            if (computeWidthFromModel) {
                this.registerModelChangeListener();
            } else {
                this.unregisterModelChangeListener();
            }
        }
    }

    public String getDisplayTextNoSelection() {
        return this.displayTextNoSelection;
    }

    public void setDisplayTextNoSelection(String displayTextNoSelection) {
        if (displayTextNoSelection == null) {
            throw new NullPointerException("displayTextNoSelection");
        }
        this.displayTextNoSelection = displayTextNoSelection;
        this.updateLabel();
    }

    public boolean isNoSelectionIsError() {
        return this.noSelectionIsError;
    }

    public void setNoSelectionIsError(boolean noSelectionIsError) {
        this.noSelectionIsError = noSelectionIsError;
        this.updateLabel();
    }

    private void registerModelChangeListener() {
        ListModel<T> model = this.getModel();
        if (model != null) {
            this.modelWidth = -1;
            if (this.modelChangeListener == null) {
                this.modelChangeListener = new ModelChangeListener();
            }
            model.addChangeListener(this.modelChangeListener);
        }
    }

    private void unregisterModelChangeListener() {
        ListModel<T> model;
        if (this.modelChangeListener != null && (model = this.getModel()) != null) {
            model.removeChangeListener(this.modelChangeListener);
        }
    }

    @Override
    protected boolean openPopup() {
        if (super.openPopup()) {
            this.popup.validateLayout();
            this.listbox.scrollToSelected();
            return true;
        }
        return false;
    }

    protected void listBoxSelectionChanged(boolean close) {
        this.updateLabel();
        if (close) {
            this.popup.closePopup();
        }
        this.doCallback();
    }

    protected String getModelData(int idx) {
        return String.valueOf(this.getModel().getEntry(idx));
    }

    @Override
    protected Widget getLabel() {
        return this.label;
    }

    protected void updateLabel() {
        int selected = this.getSelected();
        if (selected == -1) {
            this.label.setText(this.displayTextNoSelection);
            this.label.getAnimationState().setAnimationState(STATE_ERROR, this.noSelectionIsError);
        } else {
            this.label.setText(this.getModelData(selected));
            this.label.getAnimationState().setAnimationState(STATE_ERROR, false);
        }
        if (!this.computeWidthFromModel) {
            this.invalidateLayout();
        }
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.modelWidth = -1;
    }

    @Override
    protected boolean handleEvent(Event evt) {
        if (super.handleEvent(evt)) {
            return true;
        }
        if (evt.isKeyPressedEvent()) {
            switch (evt.getKeyCode()) {
                case 199: 
                case 200: 
                case 207: 
                case 208: {
                    this.listbox.handleEvent(evt);
                    return true;
                }
                case 28: 
                case 57: {
                    this.openPopup();
                    return true;
                }
            }
        }
        return false;
    }

    void invalidateModelWidth() {
        if (this.computeWidthFromModel) {
            this.modelWidth = -1;
            this.invalidateLayout();
        }
    }

    void updateModelWidth() {
        if (this.computeWidthFromModel) {
            this.modelWidth = 0;
            this.updateModelWidth(0, this.getModel().getNumEntries() - 1);
        }
    }

    void updateModelWidth(int first, int last) {
        if (this.computeWidthFromModel) {
            int newModelWidth = this.modelWidth;
            for (int idx = first; idx <= last; ++idx) {
                newModelWidth = Math.max(newModelWidth, this.computeEntryWidth(idx));
            }
            if (newModelWidth > this.modelWidth) {
                this.modelWidth = newModelWidth;
                this.invalidateLayout();
            }
        }
    }

    protected int computeEntryWidth(int idx) {
        int width = this.label.getBorderHorizontal();
        Font font = this.label.getFont();
        if (font != null) {
            width += font.computeMultiLineTextWidth(this.getModelData(idx));
        }
        return width;
    }

    void updateHover() {
        this.getAnimationState().setAnimationState(Label.STATE_HOVER, this.label.hover || this.button.getModel().isHover());
    }

    static class ComboboxListboxLabel
    extends ListBox.ListBoxLabel {
        ComboboxListboxLabel() {
        }

        protected boolean handleListBoxEvent(Event evt) {
            if (evt.getType() == Event.Type.MOUSE_CLICKED) {
                this.doListBoxCallback(ListBox.CallbackReason.MOUSE_CLICK);
                return true;
            }
            if (evt.getType() == Event.Type.MOUSE_BTNDOWN) {
                this.doListBoxCallback(ListBox.CallbackReason.SET_SELECTED);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ComboboxListbox<T>
    extends ListBox<T> {
        public ComboboxListbox() {
            this.setTheme("listbox");
        }

        @Override
        protected ListBoxDisplay createDisplay() {
            return new ComboboxListboxLabel();
        }
    }

    class ModelChangeListener
    implements ListModel.ChangeListener {
        ModelChangeListener() {
        }

        public void entriesInserted(int first, int last) {
            ComboBox.this.updateModelWidth(first, last);
        }

        public void entriesDeleted(int first, int last) {
            ComboBox.this.invalidateModelWidth();
        }

        public void entriesChanged(int first, int last) {
            ComboBox.this.invalidateModelWidth();
        }

        public void allChanged() {
            ComboBox.this.invalidateModelWidth();
        }
    }

    class ComboboxLabel
    extends Label {
        boolean hover;

        public ComboboxLabel(AnimationState animState) {
            super(animState);
            this.setAutoSize(false);
            this.setClip(true);
            this.setTheme("display");
        }

        public int getPreferredInnerWidth() {
            if (ComboBox.this.computeWidthFromModel && ComboBox.this.getModel() != null) {
                if (ComboBox.this.modelWidth == -1) {
                    ComboBox.this.updateModelWidth();
                }
                return ComboBox.this.modelWidth;
            }
            return super.getPreferredInnerWidth();
        }

        public int getPreferredInnerHeight() {
            int prefHeight = super.getPreferredInnerHeight();
            if (this.getFont() != null) {
                prefHeight = Math.max(prefHeight, this.getFont().getLineHeight());
            }
            return prefHeight;
        }

        protected void handleMouseHover(Event evt) {
            if (evt.isMouseEvent()) {
                boolean newHover;
                boolean bl = newHover = evt.getType() != Event.Type.MOUSE_EXITED;
                if (newHover != this.hover) {
                    this.hover = newHover;
                    ComboBox.this.updateHover();
                }
            }
        }
    }
}

