/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.CallbackWithReason;
import de.matthiasmann.twl.ComboBoxBase;
import de.matthiasmann.twl.DatePicker;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.Label;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.model.DateModel;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Locale;

public class DatePickerComboBox
extends ComboBoxBase {
    private final ComboboxLabel label;
    private final DatePicker datePicker;

    public DatePickerComboBox() {
        this(Locale.getDefault(), DateFormat.getDateInstance());
    }

    public DatePickerComboBox(Locale locale, int style) {
        this(locale, DateFormat.getDateInstance(style, locale));
    }

    public DatePickerComboBox(Locale locale, DateFormat dateFormat) {
        L l = new L();
        this.label = new ComboboxLabel(this.getAnimationState());
        this.label.setTheme("display");
        this.label.addCallback(l);
        this.datePicker = new DatePicker(locale, dateFormat);
        this.datePicker.addCallback(l);
        this.popup.add(this.datePicker);
        this.popup.setTheme("datepickercomboboxPopup");
        this.button.getModel().addStateCallback(l);
        this.add(this.label);
    }

    public void setModel(DateModel model) {
        this.datePicker.setModel(model);
    }

    public DateModel getModel() {
        return this.datePicker.getModel();
    }

    public void setDateFormat(Locale locale, DateFormat dateFormat) {
        this.datePicker.setDateFormat(locale, dateFormat);
    }

    public DateFormat getDateFormat() {
        return this.datePicker.getDateFormat();
    }

    public Locale getLocale() {
        return this.datePicker.getLocale();
    }

    protected ComboboxLabel getLabel() {
        return this.label;
    }

    protected DatePicker getDatePicker() {
        return this.datePicker;
    }

    protected void setPopupSize() {
        int minWidth = this.popup.getMinWidth();
        int minHeight = this.popup.getMinHeight();
        int popupWidth = DatePickerComboBox.computeSize(minWidth, this.popup.getPreferredWidth(), this.popup.getMaxWidth());
        int popupHeight = DatePickerComboBox.computeSize(minHeight, this.popup.getPreferredHeight(), this.popup.getMaxHeight());
        Widget container = this.popup.getParent();
        int popupMaxRight = container.getInnerRight();
        int popupMaxBottom = container.getInnerBottom();
        int x = this.getX();
        int y = this.getBottom();
        if (x + popupWidth > popupMaxRight) {
            x = this.getRight() - popupWidth >= container.getInnerX() ? this.getRight() - popupWidth : popupMaxRight - minWidth;
        }
        if (y + popupHeight > popupMaxBottom) {
            y = this.getY() - popupHeight >= container.getInnerY() ? this.getY() - popupHeight : popupMaxBottom - minHeight;
        }
        popupWidth = Math.min(popupWidth, popupMaxRight - x);
        popupHeight = Math.min(popupHeight, popupMaxBottom - y);
        this.popup.setPosition(x, y);
        this.popup.setSize(popupWidth, popupHeight);
    }

    protected void updateLabel() {
        this.label.setText(this.datePicker.formatDate());
    }

    void updateHover() {
        this.getAnimationState().setAnimationState(Label.STATE_HOVER, this.label.hover || this.button.getModel().isHover());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class L
    implements Runnable,
    CallbackWithReason<Label.CallbackReason>,
    DatePicker.Callback {
        L() {
        }

        @Override
        public void run() {
            DatePickerComboBox.this.updateHover();
        }

        @Override
        public void callback(Label.CallbackReason reason) {
            DatePickerComboBox.this.openPopup();
        }

        @Override
        public void calendarChanged(Calendar calendar) {
            DatePickerComboBox.this.updateLabel();
        }
    }

    protected class ComboboxLabel
    extends Label {
        boolean hover;

        public ComboboxLabel(AnimationState animState) {
            super(animState);
            this.setAutoSize(false);
            this.setClip(true);
            this.setTheme("display");
        }

        public int getPreferredInnerHeight() {
            int prefHeight = super.getPreferredInnerHeight();
            if (this.getFont() != null) {
                prefHeight = Math.max(prefHeight, this.getFont().getLineHeight());
            }
            return prefHeight;
        }

        protected void handleMouseHover(Event evt) {
            if (evt.isMouseEvent()) {
                boolean newHover;
                boolean bl = newHover = evt.getType() != Event.Type.MOUSE_EXITED;
                if (newHover != this.hover) {
                    this.hover = newHover;
                    DatePickerComboBox.this.updateHover();
                }
            }
        }
    }
}

