/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.Table;
import de.matthiasmann.twl.TableRowSelectionManager;
import de.matthiasmann.twl.TableSearchWindow;
import de.matthiasmann.twl.model.AbstractTableModel;
import de.matthiasmann.twl.model.DefaultTableSelectionModel;
import de.matthiasmann.twl.model.FileSystemModel;
import de.matthiasmann.twl.model.SortOrder;
import de.matthiasmann.twl.model.TableSelectionModel;
import de.matthiasmann.twl.model.TableSingleSelectionModel;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twl.utils.NaturalSortComparator;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;

public class FileTable
extends Table {
    private final FileTableModel fileTableModel;
    private final Runnable selectionChangedListener;
    private TableSelectionModel fileTableSelectionModel;
    private TableSearchWindow tableSearchWindow;
    private SortColumn sortColumn = SortColumn.NAME;
    private SortOrder sortOrder = SortOrder.ASCENDING;
    private boolean allowMultiSelection;
    private FileSystemModel.FileFilter fileFilter = null;
    private boolean showFolders = true;
    private boolean showHidden = false;
    private FileSystemModel fsm;
    private Object currentFolder;
    private Callback[] fileTableCallbacks;
    static Entry[] EMPTY = new Entry[0];

    public FileTable() {
        this.fileTableModel = new FileTableModel();
        this.setModel(this.fileTableModel);
        this.selectionChangedListener = new Runnable(){

            public void run() {
                FileTable.this.selectionChanged();
            }
        };
    }

    public void addCallback(Callback callback) {
        this.fileTableCallbacks = CallbackSupport.addCallbackToList(this.fileTableCallbacks, callback, Callback.class);
    }

    public void removeCallback(Callback callback) {
        this.fileTableCallbacks = CallbackSupport.removeCallbackFromList(this.fileTableCallbacks, callback);
    }

    public boolean getShowFolders() {
        return this.showFolders;
    }

    public void setShowFolders(boolean showFolders) {
        if (this.showFolders != showFolders) {
            this.showFolders = showFolders;
            this.refreshFileTable();
        }
    }

    public boolean getShowHidden() {
        return this.showHidden;
    }

    public void setShowHidden(boolean showHidden) {
        if (this.showHidden != showHidden) {
            this.showHidden = showHidden;
            this.refreshFileTable();
        }
    }

    public void setFileFilter(FileSystemModel.FileFilter filter) {
        this.fileFilter = filter;
        this.refreshFileTable();
    }

    public FileSystemModel.FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public Entry[] getSelection() {
        return this.fileTableModel.getEntries(this.fileTableSelectionModel.getSelection());
    }

    public void setSelection(Object ... files) {
        this.fileTableSelectionModel.clearSelection();
        for (Object file : files) {
            int idx = this.fileTableModel.findFile(file);
            if (idx < 0) continue;
            this.fileTableSelectionModel.addSelection(idx, idx);
        }
    }

    public boolean setSelection(Object file) {
        this.fileTableSelectionModel.clearSelection();
        int idx = this.fileTableModel.findFile(file);
        if (idx >= 0) {
            this.fileTableSelectionModel.addSelection(idx, idx);
            this.scrollToRow(idx);
            return true;
        }
        return false;
    }

    public void clearSelection() {
        this.fileTableSelectionModel.clearSelection();
    }

    public void setSortColumn(SortColumn column) {
        if (column == null) {
            throw new NullPointerException("column");
        }
        if (this.sortColumn != column) {
            this.sortColumn = column;
            this.sortingChanged();
        }
    }

    public void setSortOrder(SortOrder order) {
        if (order == null) {
            throw new NullPointerException("order");
        }
        if (this.sortOrder != order) {
            this.sortOrder = order;
            this.sortingChanged();
        }
    }

    public boolean getAllowMultiSelection() {
        return this.allowMultiSelection;
    }

    public void setAllowMultiSelection(boolean allowMultiSelection) {
        this.allowMultiSelection = allowMultiSelection;
        if (this.fileTableSelectionModel != null) {
            this.fileTableSelectionModel.removeSelectionChangeListener(this.selectionChangedListener);
        }
        if (this.tableSearchWindow != null) {
            this.tableSearchWindow.setModel(null, 0);
        }
        this.fileTableSelectionModel = allowMultiSelection ? new DefaultTableSelectionModel() : new TableSingleSelectionModel();
        this.fileTableSelectionModel.addSelectionChangeListener(this.selectionChangedListener);
        this.tableSearchWindow = new TableSearchWindow(this, this.fileTableSelectionModel);
        this.tableSearchWindow.setModel(this.fileTableModel, 0);
        this.setSelectionManager(new TableRowSelectionManager(this.fileTableSelectionModel));
        this.setKeyboardSearchHandler(this.tableSearchWindow);
        this.selectionChanged();
    }

    public FileSystemModel getFileSystemModel() {
        return this.fsm;
    }

    public final Object getCurrentFolder() {
        return this.currentFolder;
    }

    public final boolean isRoot() {
        return this.currentFolder == null;
    }

    public void setCurrentFolder(FileSystemModel fsm, Object folder) {
        this.fsm = fsm;
        this.currentFolder = folder;
        this.refreshFileTable();
    }

    public void refreshFileTable() {
        Object[] objs = this.collectObjects();
        if (objs != null) {
            int lastFileIdx = objs.length;
            Entry[] entries = new Entry[lastFileIdx];
            int numFolders = 0;
            boolean isRoot = this.isRoot();
            for (int i = 0; i < objs.length; ++i) {
                Entry e = new Entry(this.fsm, objs[i], isRoot);
                if (e.isFolder) {
                    entries[numFolders++] = e;
                    continue;
                }
                entries[--lastFileIdx] = e;
            }
            Arrays.sort(entries, 0, numFolders, NameComparator.instance);
            this.sortFilesAndUpdateModel(entries, numFolders);
        } else {
            this.sortFilesAndUpdateModel(EMPTY, 0);
        }
        if (this.tableSearchWindow != null) {
            this.tableSearchWindow.cancelSearch();
        }
    }

    protected void selectionChanged() {
        if (this.fileTableCallbacks != null) {
            for (Callback cb : this.fileTableCallbacks) {
                cb.selectionChanged();
            }
        }
    }

    protected void sortingChanged() {
        this.setSortArrows();
        this.sortFilesAndUpdateModel();
        if (this.fileTableCallbacks != null) {
            for (Callback cb : this.fileTableCallbacks) {
                cb.sortingChanged();
            }
        }
    }

    private Object[] collectObjects() {
        if (this.fsm == null) {
            return null;
        }
        if (this.isRoot()) {
            return this.fsm.listRoots();
        }
        FileSystemModel.FileFilter filter = this.fileFilter;
        if (filter != null || !this.getShowFolders() || !this.getShowHidden()) {
            filter = new FileFilterWrapper(filter, this.getShowFolders(), this.getShowHidden());
        }
        return this.fsm.listFolder(this.currentFolder, filter);
    }

    private void sortFilesAndUpdateModel(Entry[] entries, int numFolders) {
        StateSnapshot snapshot = this.makeSnapshot();
        Arrays.sort(entries, numFolders, entries.length, this.sortOrder.map(this.sortColumn.comparator));
        this.fileTableModel.setData(entries, numFolders);
        this.restoreSnapshot(snapshot);
    }

    protected void columnHeaderClicked(int column) {
        super.columnHeaderClicked(column);
        SortColumn thisColumn = SortColumn.values()[column];
        if (this.sortColumn == thisColumn) {
            this.setSortOrder(this.sortOrder.invert());
        } else {
            this.setSortColumn(thisColumn);
        }
    }

    protected void updateColumnHeaderNumbers() {
        super.updateColumnHeaderNumbers();
        this.setSortArrows();
    }

    protected void setSortArrows() {
        this.setColumnSortOrderAnimationState(this.sortColumn.ordinal(), this.sortOrder);
    }

    private void sortFilesAndUpdateModel() {
        this.sortFilesAndUpdateModel(this.fileTableModel.entries, this.fileTableModel.numFolders);
    }

    private StateSnapshot makeSnapshot() {
        return new StateSnapshot(this.fileTableModel.getEntry(this.fileTableSelectionModel.getLeadIndex()), this.fileTableModel.getEntry(this.fileTableSelectionModel.getAnchorIndex()), this.fileTableModel.getEntries(this.fileTableSelectionModel.getSelection()));
    }

    private void restoreSnapshot(StateSnapshot snapshot) {
        for (Entry e : snapshot.selected) {
            int idx = this.fileTableModel.findEntry(e);
            if (idx < 0) continue;
            this.fileTableSelectionModel.addSelection(idx, idx);
        }
        int leadIndex = this.fileTableModel.findEntry(snapshot.leadEntry);
        int anchorIndex = this.fileTableModel.findEntry(snapshot.anchorEntry);
        this.fileTableSelectionModel.setLeadIndex(leadIndex);
        this.fileTableSelectionModel.setAnchorIndex(anchorIndex);
        this.scrollToRow(Math.max(0, leadIndex));
    }

    private static class FileFilterWrapper
    implements FileSystemModel.FileFilter {
        private final FileSystemModel.FileFilter base;
        private final boolean showFolder;
        private final boolean showHidden;

        public FileFilterWrapper(FileSystemModel.FileFilter base, boolean showFolder, boolean showHidden) {
            this.base = base;
            this.showFolder = showFolder;
            this.showHidden = showHidden;
        }

        public boolean accept(FileSystemModel fsm, Object file) {
            if (this.showHidden || !fsm.isHidden(file)) {
                if (fsm.isFolder(file)) {
                    return this.showFolder;
                }
                return this.base == null || this.base.accept(fsm, file);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LastModifiedComparator
    implements Comparator<Entry> {
        static final LastModifiedComparator instance = new LastModifiedComparator();

        LastModifiedComparator() {
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            Date lm1 = o1.lastModified;
            Date lm2 = o2.lastModified;
            if (lm1 != null && lm2 != null) {
                return lm1.compareTo(lm2);
            }
            if (lm1 != null) {
                return 1;
            }
            if (lm2 != null) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SizeComparator
    implements Comparator<Entry> {
        static final SizeComparator instance = new SizeComparator();

        SizeComparator() {
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            return Long.signum(o1.size - o2.size);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExtensionComparator
    implements Comparator<Entry> {
        static final ExtensionComparator instance = new ExtensionComparator();

        ExtensionComparator() {
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            return NaturalSortComparator.naturalCompare(o1.getExtension(), o2.getExtension());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NameComparator
    implements Comparator<Entry> {
        static final NameComparator instance = new NameComparator();

        NameComparator() {
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            return NaturalSortComparator.naturalCompare(o1.name, o2.name);
        }
    }

    static class StateSnapshot {
        final Entry leadEntry;
        final Entry anchorEntry;
        final Entry[] selected;

        StateSnapshot(Entry leadEntry, Entry anchorEntry, Entry[] selected) {
            this.leadEntry = leadEntry;
            this.anchorEntry = anchorEntry;
            this.selected = selected;
        }
    }

    static class FileTableModel
    extends AbstractTableModel {
        private final DateFormat dateFormat = DateFormat.getDateInstance();
        Entry[] entries = EMPTY;
        int numFolders;
        static String[] COLUMN_HEADER = new String[]{"File name", "Type", "Size", "Last modified"};
        static String[] SIZE_UNITS = new String[]{" MB", " KB", " B"};
        static long[] SIZE_FACTORS = new long[]{0x100000L, 1024L, 1L};

        FileTableModel() {
        }

        public void setData(Entry[] entries, int numFolders) {
            this.fireRowsDeleted(0, this.getNumRows());
            this.entries = entries;
            this.numFolders = numFolders;
            this.fireRowsInserted(0, this.getNumRows());
        }

        public String getColumnHeaderText(int column) {
            return COLUMN_HEADER[column];
        }

        public int getNumColumns() {
            return COLUMN_HEADER.length;
        }

        public Object getCell(int row, int column) {
            Entry e = this.entries[row];
            if (e.isFolder) {
                switch (column) {
                    case 0: {
                        return "[" + e.name + "]";
                    }
                    case 1: {
                        return "Folder";
                    }
                    case 2: {
                        return "";
                    }
                    case 3: {
                        return this.formatDate(e.lastModified);
                    }
                }
                return "??";
            }
            switch (column) {
                case 0: {
                    return e.name;
                }
                case 1: {
                    String ext = e.getExtension();
                    return ext.length() == 0 ? "File" : ext + "-file";
                }
                case 2: {
                    return this.formatFileSize(e.size);
                }
                case 3: {
                    return this.formatDate(e.lastModified);
                }
            }
            return "??";
        }

        public Object getTooltipContent(int row, int column) {
            Entry e = this.entries[row];
            StringBuilder sb = new StringBuilder(e.name);
            if (!e.isFolder) {
                sb.append("\nSize: ").append(this.formatFileSize(e.size));
            }
            if (e.lastModified != null) {
                sb.append("\nLast modified: ").append(this.formatDate(e.lastModified));
            }
            return sb.toString();
        }

        public int getNumRows() {
            return this.entries.length;
        }

        Entry getEntry(int row) {
            if (row >= 0 && row < this.entries.length) {
                return this.entries[row];
            }
            return null;
        }

        int findEntry(Entry entry) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (!this.entries[i].equals(entry)) continue;
                return i;
            }
            return -1;
        }

        int findFile(Object file) {
            for (int i = 0; i < this.entries.length; ++i) {
                Entry e = this.entries[i];
                if (!e.fsm.equals(e.obj, file)) continue;
                return i;
            }
            return -1;
        }

        Entry[] getEntries(int[] selection) {
            int count = selection.length;
            if (count == 0) {
                return EMPTY;
            }
            Entry[] result = new Entry[count];
            for (int i = 0; i < count; ++i) {
                result[i] = this.entries[selection[i]];
            }
            return result;
        }

        private String formatFileSize(long size) {
            if (size <= 0L) {
                return "0 B";
            }
            int i = 0;
            while (true) {
                if (size >= SIZE_FACTORS[i]) {
                    long value = size * 10L / SIZE_FACTORS[i];
                    return Long.toString(value / 10L) + '.' + Character.forDigit((int)(value % 10L), 10) + SIZE_UNITS[i];
                }
                ++i;
            }
        }

        private String formatDate(Date date) {
            if (date == null) {
                return "";
            }
            return this.dateFormat.format(date);
        }
    }

    public static final class Entry {
        public final FileSystemModel fsm;
        public final Object obj;
        public final String name;
        public final boolean isFolder;
        public final long size;
        public final Date lastModified;

        public Entry(FileSystemModel fsm, Object obj, boolean isRoot) {
            this.fsm = fsm;
            this.obj = obj;
            this.name = fsm.getName(obj);
            if (isRoot) {
                this.isFolder = true;
                this.lastModified = null;
            } else {
                this.isFolder = fsm.isFolder(obj);
                this.lastModified = new Date(fsm.getLastModified(obj));
            }
            this.size = this.isFolder ? 0L : fsm.getSize(obj);
        }

        public String getExtension() {
            int idx = this.name.lastIndexOf(46);
            if (idx >= 0) {
                return this.name.substring(idx + 1);
            }
            return "";
        }

        public String getPath() {
            return this.fsm.getPath(this.obj);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry that = (Entry)o;
            return this.fsm == that.fsm && this.fsm.equals(this.obj, that.obj);
        }

        public int hashCode() {
            return this.obj != null ? this.obj.hashCode() : 203;
        }
    }

    public static interface Callback {
        public void selectionChanged();

        public void sortingChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortColumn {
        NAME(NameComparator.instance),
        TYPE(ExtensionComparator.instance),
        SIZE(SizeComparator.instance),
        LAST_MODIFIED(LastModifiedComparator.instance);

        final Comparator<Entry> comparator;

        private SortColumn(Comparator<Entry> comparator) {
            this.comparator = comparator;
        }
    }
}

