/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.Dimension;
import de.matthiasmann.twl.DraggableButton;
import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ParameterMap;
import de.matthiasmann.twl.Rect;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Font;
import de.matthiasmann.twl.renderer.FontCache;
import de.matthiasmann.twl.renderer.FontMapper;
import de.matthiasmann.twl.renderer.FontParameter;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.textarea.OrderedListType;
import de.matthiasmann.twl.textarea.Style;
import de.matthiasmann.twl.textarea.StyleAttribute;
import de.matthiasmann.twl.textarea.StyleSheet;
import de.matthiasmann.twl.textarea.StyleSheetResolver;
import de.matthiasmann.twl.textarea.TextAreaModel;
import de.matthiasmann.twl.textarea.TextDecoration;
import de.matthiasmann.twl.textarea.Value;
import de.matthiasmann.twl.theme.StateSelectImage;
import de.matthiasmann.twl.utils.CallbackSupport;
import de.matthiasmann.twl.utils.StateExpression;
import de.matthiasmann.twl.utils.StateSelect;
import de.matthiasmann.twl.utils.StringList;
import de.matthiasmann.twl.utils.TextUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextArea
extends Widget {
    public static final AnimationState.StateKey STATE_HOVER = AnimationState.StateKey.get("hover");
    static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private final HashMap<String, Widget> widgets = new HashMap();
    private final HashMap<String, WidgetResolver> widgetResolvers = new HashMap();
    private final HashMap<String, Image> userImages = new HashMap();
    private final ArrayList<ImageResolver> imageResolvers = new ArrayList();
    StyleSheetResolver styleClassResolver;
    private final Runnable modelCB;
    private TextAreaModel model;
    private ParameterMap fonts;
    private ParameterMap images;
    private Font defaultFont;
    private Callback[] callbacks;
    private MouseCursor mouseCursorNormal;
    private MouseCursor mouseCursorLink;
    private DraggableButton.DragListener dragListener;
    private final LClip layoutRoot = new LClip(null);
    private final ArrayList<LImage> allBGImages = new ArrayList();
    private final RenderInfo renderInfo = new RenderInfo(this.getAnimationState());
    private boolean inLayoutCode;
    private boolean forceRelayout;
    private Dimension preferredInnerSize;
    private FontMapper fontMapper;
    private FontMapperCacheEntry[] fontMapperCache;
    private int lastMouseX;
    private int lastMouseY;
    private boolean lastMouseInside;
    private boolean dragging;
    private int dragStartX;
    private int dragStartY;
    private LElement curLElementUnderMouse;
    private static final int DEFAULT_FONT_SIZE = 14;
    private static final StateSelect HOVER_STATESELECT = new StateSelect(new StateExpression.Check(STATE_HOVER));
    private static final int FONT_MAPPER_CACHE_SIZE = 16;

    public TextArea() {
        this.modelCB = new Runnable(){

            public void run() {
                TextArea.this.forceRelayout();
            }
        };
    }

    public TextArea(TextAreaModel model) {
        this();
        this.setModel(model);
    }

    public TextAreaModel getModel() {
        return this.model;
    }

    public void setModel(TextAreaModel model) {
        if (this.model != null) {
            this.model.removeCallback(this.modelCB);
        }
        this.model = model;
        if (model != null) {
            model.addCallback(this.modelCB);
        }
        this.forceRelayout();
    }

    public void registerWidget(String name, Widget widget) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (widget.getParent() != null) {
            throw new IllegalArgumentException("Widget must not have a parent");
        }
        if (this.widgets.containsKey(name) || this.widgetResolvers.containsKey(name)) {
            throw new IllegalArgumentException("widget name already in registered");
        }
        if (this.widgets.containsValue(widget)) {
            throw new IllegalArgumentException("widget already registered");
        }
        this.widgets.put(name, widget);
    }

    public void registerWidgetResolver(String name, WidgetResolver resolver) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (resolver == null) {
            throw new NullPointerException("resolver");
        }
        if (this.widgets.containsKey(name) || this.widgetResolvers.containsKey(name)) {
            throw new IllegalArgumentException("widget name already in registered");
        }
        this.widgetResolvers.put(name, resolver);
    }

    public void unregisterWidgetResolver(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.widgetResolvers.remove(name);
    }

    public void unregisterWidget(String name) {
        int idx;
        if (name == null) {
            throw new NullPointerException("name");
        }
        Widget w = this.widgets.get(name);
        if (w != null && (idx = this.getChildIndex(w)) >= 0) {
            super.removeChild(idx);
            this.forceRelayout();
        }
    }

    public void unregisterAllWidgets() {
        this.widgets.clear();
        super.removeAllChildren();
        this.forceRelayout();
    }

    public void registerImage(String name, Image image) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.userImages.put(name, image);
    }

    public void registerImageResolver(ImageResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException("resolver");
        }
        if (!this.imageResolvers.contains(resolver)) {
            this.imageResolvers.add(resolver);
        }
    }

    public void unregisterImage(String name) {
        this.userImages.remove(name);
    }

    public void unregisterImageResolver(ImageResolver imageResolver) {
        this.imageResolvers.remove(imageResolver);
    }

    public void addCallback(Callback cb) {
        this.callbacks = CallbackSupport.addCallbackToList(this.callbacks, cb, Callback.class);
    }

    public void removeCallback(Callback cb) {
        this.callbacks = CallbackSupport.removeCallbackFromList(this.callbacks, cb);
    }

    public DraggableButton.DragListener getDragListener() {
        return this.dragListener;
    }

    public void setDragListener(DraggableButton.DragListener dragListener) {
        this.dragListener = dragListener;
    }

    public StyleSheetResolver getStyleClassResolver() {
        return this.styleClassResolver;
    }

    public void setStyleClassResolver(StyleSheetResolver styleClassResolver) {
        this.styleClassResolver = styleClassResolver;
        this.forceRelayout();
    }

    public void setDefaultStyleSheet() {
        try {
            StyleSheet styleSheet = new StyleSheet();
            styleSheet.parse("p,ul{margin-bottom:1em}");
            this.setStyleClassResolver(styleSheet);
        }
        catch (IOException ex) {
            Logger.getLogger(TextArea.class.getName()).log(Level.SEVERE, "Can't create default style sheet", ex);
        }
    }

    public Rect getElementRect(TextAreaModel.Element element) {
        int[] offset = new int[2];
        LElement le = this.layoutRoot.find(element, offset);
        if (le != null) {
            return new Rect(le.x + offset[0], le.y + offset[1], le.width, le.height);
        }
        return null;
    }

    @Override
    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.applyThemeTextArea(themeInfo);
    }

    protected void applyThemeTextArea(ThemeInfo themeInfo) {
        this.fonts = themeInfo.getParameterMap("fonts");
        this.images = themeInfo.getParameterMap("images");
        this.defaultFont = themeInfo.getFont("font");
        this.mouseCursorNormal = themeInfo.getMouseCursor("mouseCursor");
        this.mouseCursorLink = themeInfo.getMouseCursor("mouseCursor.link");
        this.forceRelayout();
    }

    @Override
    protected void afterAddToGUI(GUI gui) {
        super.afterAddToGUI(gui);
        this.renderInfo.asNormal.setGUI(gui);
        this.renderInfo.asHover.setGUI(gui);
    }

    @Override
    public void insertChild(Widget child, int index) {
        throw new UnsupportedOperationException("use registerWidget");
    }

    @Override
    public void removeAllChildren() {
        throw new UnsupportedOperationException("use registerWidget");
    }

    @Override
    public Widget removeChild(int index) {
        throw new UnsupportedOperationException("use registerWidget");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computePreferredInnerSize() {
        int prefWidth = -1;
        int prefHeight = -1;
        if (this.model == null) {
            prefWidth = 0;
            prefHeight = 0;
        } else if (this.getMaxWidth() > 0) {
            int borderHorizontal = this.getBorderHorizontal();
            int maxWidth = Math.max(0, this.getMaxWidth() - borderHorizontal);
            int minWidth = Math.max(0, this.getMinWidth() - borderHorizontal);
            if (minWidth < maxWidth) {
                LClip tmpRoot = new LClip(null);
                this.startLayout();
                try {
                    tmpRoot.width = maxWidth;
                    Box box = new Box(tmpRoot, 0, 0, 0, false);
                    this.layoutElements(box, this.model);
                    box.finish();
                    prefWidth = Math.max(0, maxWidth - box.minRemainingWidth);
                    prefHeight = box.curY;
                }
                finally {
                    this.endLayout();
                }
            }
        }
        this.preferredInnerSize = new Dimension(prefWidth, prefHeight);
    }

    @Override
    public int getPreferredInnerWidth() {
        if (this.preferredInnerSize == null) {
            this.computePreferredInnerSize();
        }
        if (this.preferredInnerSize.getX() >= 0) {
            return this.preferredInnerSize.getX();
        }
        return this.getInnerWidth();
    }

    @Override
    public int getPreferredInnerHeight() {
        if (this.getInnerWidth() == 0) {
            if (this.preferredInnerSize == null) {
                this.computePreferredInnerSize();
            }
            if (this.preferredInnerSize.getY() >= 0) {
                return this.preferredInnerSize.getY();
            }
        }
        this.validateLayout();
        return this.layoutRoot.height;
    }

    @Override
    public int getPreferredWidth() {
        int maxWidth = this.getMaxWidth();
        return TextArea.computeSize(this.getMinWidth(), super.getPreferredWidth(), maxWidth);
    }

    @Override
    public void setMaxSize(int width, int height) {
        if (width != this.getMaxWidth()) {
            this.preferredInnerSize = null;
            this.invalidateLayout();
        }
        super.setMaxSize(width, height);
    }

    @Override
    public void setMinSize(int width, int height) {
        if (width != this.getMinWidth()) {
            this.preferredInnerSize = null;
            this.invalidateLayout();
        }
        super.setMinSize(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void layout() {
        int targetWidth = this.getInnerWidth();
        if (this.layoutRoot.width != targetWidth || this.forceRelayout) {
            int requiredHeight;
            this.layoutRoot.width = targetWidth;
            this.inLayoutCode = true;
            this.forceRelayout = false;
            this.startLayout();
            try {
                this.clearLayout();
                Box box = new Box(this.layoutRoot, 0, 0, 0, true);
                if (this.model != null) {
                    this.layoutElements(box, this.model);
                    box.finish();
                    this.layoutRoot.adjustWidget(this.getInnerX(), this.getInnerY());
                    this.layoutRoot.collectBGImages(0, 0, this.allBGImages);
                }
                this.updateMouseHover();
                requiredHeight = box.curY;
            }
            finally {
                this.inLayoutCode = false;
                this.endLayout();
            }
            if (this.layoutRoot.height != requiredHeight) {
                this.layoutRoot.height = requiredHeight;
                if (this.getInnerHeight() != requiredHeight) {
                    this.invalidateLayout();
                }
            }
        }
    }

    @Override
    protected void paintWidget(GUI gui) {
        ArrayList<LImage> bi = this.allBGImages;
        RenderInfo ri = this.renderInfo;
        ri.offsetX = this.getInnerX();
        ri.offsetY = this.getInnerY();
        ri.renderer = gui.getRenderer();
        int n = bi.size();
        for (int i = 0; i < n; ++i) {
            bi.get(i).draw(ri);
        }
        this.layoutRoot.draw(ri);
    }

    @Override
    protected void sizeChanged() {
        if (!this.inLayoutCode) {
            this.invalidateLayout();
        }
    }

    @Override
    protected void childAdded(Widget child) {
    }

    @Override
    protected void childRemoved(Widget exChild) {
    }

    @Override
    protected void allChildrenRemoved() {
    }

    @Override
    public void destroy() {
        super.destroy();
        this.clearLayout();
        this.forceRelayout();
    }

    @Override
    protected boolean handleEvent(Event evt) {
        if (super.handleEvent(evt)) {
            return true;
        }
        if (evt.isMouseEvent()) {
            Event.Type eventType = evt.getType();
            if (this.dragging) {
                if (eventType == Event.Type.MOUSE_DRAGGED && this.dragListener != null) {
                    this.dragListener.dragged(evt.getMouseX() - this.dragStartX, evt.getMouseY() - this.dragStartY);
                }
                if (evt.isMouseDragEnd()) {
                    if (this.dragListener != null) {
                        this.dragListener.dragStopped();
                    }
                    this.dragging = false;
                    this.updateMouseHover(evt);
                }
                return true;
            }
            this.updateMouseHover(evt);
            if (eventType == Event.Type.MOUSE_WHEEL) {
                return false;
            }
            if (eventType == Event.Type.MOUSE_BTNDOWN) {
                this.dragStartX = evt.getMouseX();
                this.dragStartY = evt.getMouseY();
            }
            if (eventType == Event.Type.MOUSE_DRAGGED) {
                assert (!this.dragging);
                this.dragging = true;
                if (this.dragListener != null) {
                    this.dragListener.dragStarted();
                }
                return true;
            }
            if (this.curLElementUnderMouse != null && (eventType == Event.Type.MOUSE_CLICKED || eventType == Event.Type.MOUSE_BTNDOWN || eventType == Event.Type.MOUSE_BTNUP)) {
                TextAreaModel.Element e = this.curLElementUnderMouse.element;
                if (this.callbacks != null) {
                    for (Callback l : this.callbacks) {
                        if (!(l instanceof Callback2)) continue;
                        ((Callback2)l).handleMouseButton(evt, e);
                    }
                }
            }
            if (eventType == Event.Type.MOUSE_CLICKED && this.curLElementUnderMouse != null && this.curLElementUnderMouse.href != null) {
                String href = this.curLElementUnderMouse.href;
                if (this.callbacks != null) {
                    for (Callback l : this.callbacks) {
                        l.handleLinkClicked(href);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected Object getTooltipContentAt(int mouseX, int mouseY) {
        if (this.curLElementUnderMouse != null && this.curLElementUnderMouse.element instanceof TextAreaModel.ImageElement) {
            return ((TextAreaModel.ImageElement)this.curLElementUnderMouse.element).getToolTip();
        }
        return super.getTooltipContentAt(mouseX, mouseY);
    }

    private void updateMouseHover(Event evt) {
        this.lastMouseInside = this.isMouseInside(evt);
        this.lastMouseX = evt.getMouseX();
        this.lastMouseY = evt.getMouseY();
        this.updateMouseHover();
    }

    private void updateMouseHover() {
        LElement le = null;
        if (this.lastMouseInside) {
            le = this.layoutRoot.find(this.lastMouseX - this.getInnerX(), this.lastMouseY - this.getInnerY());
        }
        if (this.curLElementUnderMouse != le) {
            this.curLElementUnderMouse = le;
            this.layoutRoot.setHover(le);
            this.renderInfo.asNormal.resetAnimationTime(STATE_HOVER);
            this.renderInfo.asHover.resetAnimationTime(STATE_HOVER);
            this.updateTooltip();
        }
        if (le != null && le.href != null) {
            this.setMouseCursor(this.mouseCursorLink);
        } else {
            this.setMouseCursor(this.mouseCursorNormal);
        }
        this.getAnimationState().setAnimationState(STATE_HOVER, this.lastMouseInside);
    }

    void forceRelayout() {
        this.forceRelayout = true;
        this.preferredInnerSize = null;
        this.invalidateLayout();
    }

    private void clearLayout() {
        this.layoutRoot.destroy();
        this.allBGImages.clear();
        super.removeAllChildren();
    }

    private void startLayout() {
        GUI gui;
        if (this.styleClassResolver != null) {
            this.styleClassResolver.startLayout();
        }
        this.fontMapper = (gui = this.getGUI()) != null ? gui.getRenderer().getFontMapper() : null;
        this.fontMapperCache = null;
    }

    private void endLayout() {
        if (this.styleClassResolver != null) {
            this.styleClassResolver.layoutFinished();
        }
        this.fontMapper = null;
        this.fontMapperCache = null;
    }

    private void layoutElements(Box box, Iterable<TextAreaModel.Element> elements) {
        for (TextAreaModel.Element e : elements) {
            this.layoutElement(box, e);
        }
    }

    private void layoutElement(Box box, TextAreaModel.Element e) {
        box.clearFloater(e.getStyle().get(StyleAttribute.CLEAR, this.styleClassResolver));
        if (e instanceof TextAreaModel.TextElement) {
            this.layoutTextElement(box, (TextAreaModel.TextElement)e);
        } else {
            if (box.wasPreformatted) {
                box.nextLine(false);
                box.wasPreformatted = false;
            }
            if (e instanceof TextAreaModel.ParagraphElement) {
                this.layoutParagraphElement(box, (TextAreaModel.ParagraphElement)e);
            } else if (e instanceof TextAreaModel.ImageElement) {
                this.layoutImageElement(box, (TextAreaModel.ImageElement)e);
            } else if (e instanceof TextAreaModel.WidgetElement) {
                this.layoutWidgetElement(box, (TextAreaModel.WidgetElement)e);
            } else if (e instanceof TextAreaModel.ListElement) {
                this.layoutListElement(box, (TextAreaModel.ListElement)e);
            } else if (e instanceof TextAreaModel.OrderedListElement) {
                this.layoutOrderedListElement(box, (TextAreaModel.OrderedListElement)e);
            } else if (e instanceof TextAreaModel.BlockElement) {
                this.layoutBlockElement(box, (TextAreaModel.BlockElement)e);
            } else if (e instanceof TextAreaModel.TableElement) {
                this.layoutTableElement(box, (TextAreaModel.TableElement)e);
            } else if (e instanceof TextAreaModel.LinkElement) {
                this.layoutLinkElement(box, (TextAreaModel.LinkElement)e);
            } else if (e instanceof TextAreaModel.ContainerElement) {
                this.layoutContainerElement(box, (TextAreaModel.ContainerElement)e);
            } else {
                Logger.getLogger(TextArea.class.getName()).log(Level.SEVERE, "Unknown Element subclass: {0}", e.getClass());
            }
        }
    }

    private void layoutImageElement(Box box, TextAreaModel.ImageElement ie) {
        Image image = this.selectImage(ie.getImageName());
        if (image == null) {
            return;
        }
        LImage li = new LImage(ie, image);
        li.href = box.href;
        this.layout(box, ie, li);
    }

    private void layoutWidgetElement(Box box, TextAreaModel.WidgetElement we) {
        Widget widget = this.widgets.get(we.getWidgetName());
        if (widget == null) {
            WidgetResolver resolver = this.widgetResolvers.get(we.getWidgetName());
            if (resolver != null) {
                widget = resolver.resolveWidget(we.getWidgetName(), we.getWidgetParam());
            }
            if (widget == null) {
                return;
            }
        }
        if (widget.getParent() != null) {
            Logger.getLogger(TextArea.class.getName()).log(Level.SEVERE, "Widget already added: {0}", widget);
            return;
        }
        super.insertChild(widget, this.getNumChildren());
        widget.adjustSize();
        LWidget lw = new LWidget(we, widget);
        lw.width = widget.getWidth();
        lw.height = widget.getHeight();
        this.layout(box, we, lw);
    }

    private void layout(Box box, TextAreaModel.Element e, LElement le) {
        int height;
        Style style = e.getStyle();
        TextAreaModel.FloatPosition floatPosition = style.get(StyleAttribute.FLOAT_POSITION, this.styleClassResolver);
        TextAreaModel.Display display = style.get(StyleAttribute.DISPLAY, this.styleClassResolver);
        le.marginTop = (short)this.convertToPX0(style, StyleAttribute.MARGIN_TOP, box.boxWidth);
        le.marginLeft = (short)this.convertToPX0(style, StyleAttribute.MARGIN_LEFT, box.boxWidth);
        le.marginRight = (short)this.convertToPX0(style, StyleAttribute.MARGIN_RIGHT, box.boxWidth);
        le.marginBottom = (short)this.convertToPX0(style, StyleAttribute.MARGIN_BOTTOM, box.boxWidth);
        int autoHeight = le.height;
        int width = this.convertToPX(style, StyleAttribute.WIDTH, box.boxWidth, le.width);
        if (width > 0) {
            if (le.width > 0) {
                autoHeight = width * le.height / le.width;
            }
            le.width = width;
        }
        if ((height = this.convertToPX(style, StyleAttribute.HEIGHT, le.height, autoHeight)) > 0) {
            le.height = height;
        }
        this.layout(box, e, le, floatPosition, display);
    }

    private void layout(Box box, TextAreaModel.Element e, LElement le, TextAreaModel.FloatPosition floatPos, TextAreaModel.Display display) {
        boolean leftRight;
        boolean bl = leftRight = floatPos != TextAreaModel.FloatPosition.NONE;
        if (leftRight || display != TextAreaModel.Display.INLINE) {
            box.nextLine(false);
            if (!leftRight) {
                box.curY = box.computeTopPadding(le.marginTop);
                box.checkFloaters();
            }
        }
        box.advancePastFloaters(le.width, le.marginLeft, le.marginRight);
        if (le.width > box.lineWidth) {
            le.width = box.lineWidth;
        }
        if (leftRight) {
            if (floatPos == TextAreaModel.FloatPosition.RIGHT) {
                le.x = box.computeRightPadding(le.marginRight) - le.width;
                box.objRight.add(le);
            } else {
                le.x = box.computeLeftPadding(le.marginLeft);
                box.objLeft.add(le);
            }
        } else if (display == TextAreaModel.Display.INLINE) {
            if (box.getRemaining() < le.width && !box.isAtStartOfLine()) {
                box.nextLine(false);
            }
            le.x = box.getXAndAdvance(le.width);
        } else {
            switch (e.getStyle().get(StyleAttribute.HORIZONTAL_ALIGNMENT, this.styleClassResolver)) {
                case CENTER: 
                case JUSTIFY: {
                    le.x = box.lineStartX + (box.lineWidth - le.width) / 2;
                    break;
                }
                case RIGHT: {
                    le.x = box.computeRightPadding(le.marginRight) - le.width;
                    break;
                }
                default: {
                    le.x = box.computeLeftPadding(le.marginLeft);
                }
            }
        }
        box.layout.add(le);
        if (leftRight) {
            assert (box.lineStartIdx == box.layout.size() - 1);
            ++box.lineStartIdx;
            le.y = box.computeTopPadding(le.marginTop);
            box.computePadding();
        } else if (display != TextAreaModel.Display.INLINE) {
            box.accountMinRemaining(Math.max(0, box.lineWidth - le.width));
            box.nextLine(false);
        }
    }

    int convertToPX(Style style, StyleAttribute<Value> attribute, int full, int auto) {
        style = style.resolve(attribute, this.styleClassResolver);
        Value valueUnit = style.getNoResolve(attribute, this.styleClassResolver);
        Font font = null;
        if (valueUnit.unit.isFontBased()) {
            if (attribute == StyleAttribute.FONT_SIZE && (style = style.getParent()) == null) {
                return 14;
            }
            font = this.selectFont(style);
            if (font == null) {
                return 0;
            }
        }
        float value = valueUnit.value;
        switch (valueUnit.unit) {
            case EM: {
                value *= (float)font.getEM();
                break;
            }
            case EX: {
                value *= (float)font.getEX();
                break;
            }
            case PERCENT: {
                value *= (float)full * 0.01f;
                break;
            }
            case PT: {
                value *= 1.33f;
                break;
            }
            case AUTO: {
                return auto;
            }
        }
        if (value >= 32767.0f) {
            return Short.MAX_VALUE;
        }
        if (value <= -32768.0f) {
            return Short.MIN_VALUE;
        }
        return Math.round(value);
    }

    int convertToPX0(Style style, StyleAttribute<Value> attribute, int full) {
        return Math.max(0, this.convertToPX(style, attribute, full, 0));
    }

    private Font selectFont(Style style) {
        StringList fontFamilies = style.get(StyleAttribute.FONT_FAMILIES, this.styleClassResolver);
        if (fontFamilies != null) {
            Font font;
            if (this.fontMapper != null && (font = this.selectFontMapper(style, this.fontMapper, fontFamilies)) != null) {
                return font;
            }
            if (this.fonts != null) {
                do {
                    if ((font = this.fonts.getFont(fontFamilies.getValue())) == null) continue;
                    return font;
                } while ((fontFamilies = fontFamilies.getNext()) != null);
            }
        }
        return this.defaultFont;
    }

    private Font selectFontMapper(Style style, FontMapper fontMapper, StringList fontFamilies) {
        FontParameter[] params;
        StateSelect select;
        int fontSize = this.convertToPX(style, StyleAttribute.FONT_SIZE, 14, 14);
        int fontStyle = 0;
        if (style.get(StyleAttribute.FONT_WEIGHT, this.styleClassResolver) >= 550) {
            fontStyle |= 1;
        }
        if (style.get(StyleAttribute.FONT_ITALIC, this.styleClassResolver).booleanValue()) {
            fontStyle |= 2;
        }
        TextDecoration textDecoration = style.get(StyleAttribute.TEXT_DECORATION, this.styleClassResolver);
        TextDecoration textDecorationHover = style.get(StyleAttribute.TEXT_DECORATION_HOVER, this.styleClassResolver);
        int hashCode = fontSize;
        hashCode = hashCode * 67 + fontStyle;
        hashCode = hashCode * 67 + fontFamilies.hashCode();
        hashCode = hashCode * 67 + textDecoration.hashCode();
        hashCode = hashCode * 67 + (textDecorationHover != null ? textDecorationHover.hashCode() : 0);
        int cacheIdx = hashCode & 0xF;
        if (this.fontMapperCache != null) {
            FontMapperCacheEntry ce = this.fontMapperCache[cacheIdx];
            while (ce != null) {
                if (ce.hashCode == hashCode && ce.fontSize == fontSize && ce.fontStyle == fontStyle && ce.tdNormal == textDecoration && ce.tdHover == textDecorationHover && ce.fontFamilies.equals(fontFamilies)) {
                    return ce.font;
                }
                ce = ce.next;
            }
        } else {
            this.fontMapperCache = new FontMapperCacheEntry[16];
        }
        FontParameter fpNormal = TextArea.createFontParameter(textDecoration);
        if (textDecorationHover != null) {
            FontParameter fpHover = TextArea.createFontParameter(textDecorationHover);
            select = HOVER_STATESELECT;
            params = new FontParameter[]{fpHover, fpNormal};
        } else {
            select = StateSelect.EMPTY;
            params = new FontParameter[]{fpNormal};
        }
        Font font = fontMapper.getFont(fontFamilies, fontSize, fontStyle, select, params);
        FontMapperCacheEntry ce = new FontMapperCacheEntry(fontSize, fontStyle, fontFamilies, textDecoration, textDecorationHover, hashCode, font);
        ce.next = this.fontMapperCache[cacheIdx];
        this.fontMapperCache[cacheIdx] = ce;
        return font;
    }

    private static FontParameter createFontParameter(TextDecoration deco) {
        FontParameter fp = new FontParameter();
        fp.put(FontParameter.UNDERLINE, deco == TextDecoration.UNDERLINE);
        fp.put(FontParameter.LINETHROUGH, deco == TextDecoration.LINE_THROUGH);
        return fp;
    }

    private FontData createFontData(Style style) {
        Font font = this.selectFont(style);
        if (font == null) {
            return null;
        }
        return new FontData(font, style.get(StyleAttribute.COLOR, this.styleClassResolver), style.get(StyleAttribute.COLOR_HOVER, this.styleClassResolver));
    }

    private Image selectImage(Style style, StyleAttribute<String> element) {
        String imageName = style.get(element, this.styleClassResolver);
        if (imageName != null) {
            return this.selectImage(imageName);
        }
        return null;
    }

    private Image selectImage(String name) {
        Image image = this.userImages.get(name);
        if (image != null) {
            return image;
        }
        for (int i = 0; i < this.imageResolvers.size(); ++i) {
            image = this.imageResolvers.get(i).resolveImage(name);
            if (image == null) continue;
            return image;
        }
        if (this.images != null) {
            return this.images.getImage(name);
        }
        return null;
    }

    private void layoutParagraphElement(Box box, TextAreaModel.ParagraphElement pe) {
        Style style = pe.getStyle();
        Font font = this.selectFont(style);
        this.doMarginTop(box, style);
        LElement anchor = box.addAnchor(pe);
        box.setupTextParams(style, font, true);
        this.layoutElements(box, pe);
        if (box.textAlignment == TextAreaModel.HAlignment.JUSTIFY) {
            box.textAlignment = TextAreaModel.HAlignment.LEFT;
        }
        box.nextLine(false);
        box.inParagraph = false;
        anchor.height = box.curY - anchor.y;
        this.doMarginBottom(box, style);
    }

    private void layoutTextElement(Box box, TextAreaModel.TextElement te) {
        String text = te.getText();
        Style style = te.getStyle();
        FontData fontData = this.createFontData(style);
        boolean pre = style.get(StyleAttribute.PREFORMATTED, this.styleClassResolver);
        if (fontData == null) {
            return;
        }
        Boolean inheritHoverStyle = style.resolve(StyleAttribute.INHERIT_HOVER, this.styleClassResolver).getRaw(StyleAttribute.INHERIT_HOVER);
        boolean inheritHover = inheritHoverStyle != null ? inheritHoverStyle : box.style != null && box.style == style.getParent();
        box.setupTextParams(style, fontData.font, false);
        if (pre && !box.wasPreformatted) {
            box.nextLine(false);
        }
        int idx = 0;
        while (idx < text.length()) {
            int end = TextUtil.indexOf(text, '\n', idx);
            if (pre) {
                this.layoutTextPre(box, te, fontData, text, idx, end, inheritHover);
            } else {
                this.layoutText(box, te, fontData, text, idx, end, inheritHover);
            }
            if (end < text.length() && text.charAt(end) == '\n') {
                box.nextLine(true);
            }
            idx = ++end;
        }
        box.wasPreformatted = pre;
    }

    private void layoutText(Box box, TextAreaModel.TextElement te, FontData fontData, String text, int textStart, int textEnd, boolean inheritHover) {
        int idx = textStart;
        while (textStart < textEnd && TextArea.isSkip(text.charAt(textStart))) {
            ++textStart;
        }
        boolean endsWithSpace = false;
        while (textEnd > textStart && TextArea.isSkip(text.charAt(textEnd - 1))) {
            endsWithSpace = true;
            --textEnd;
        }
        Font font = fontData.font;
        if (textStart > idx && box.prevOnLineEndsNotWithSpace()) {
            box.curX += font.getSpaceWidth();
        }
        Boolean breakWord = null;
        idx = textStart;
        while (idx < textEnd) {
            assert (!TextArea.isSkip(text.charAt(idx)));
            int end = idx;
            int visibleEnd = idx;
            if (box.textAlignment != TextAreaModel.HAlignment.JUSTIFY) {
                visibleEnd = end = idx + font.computeVisibleGlpyhs(text, idx, textEnd, box.getRemaining());
                if (end < textEnd) {
                    while (end > idx && TextArea.isPunctuation(text.charAt(end))) {
                        --end;
                    }
                    if (!TextArea.isBreak(text.charAt(end))) {
                        while (end > idx && !TextArea.isBreak(text.charAt(end - 1))) {
                            --end;
                        }
                    }
                }
                while (end > idx && TextArea.isSkip(text.charAt(end - 1))) {
                    --end;
                }
            }
            boolean advancePastFloaters = false;
            if (end == idx) {
                if (box.textAlignment != TextAreaModel.HAlignment.JUSTIFY && box.nextLine(false)) continue;
                if (breakWord == null) {
                    breakWord = te.getStyle().get(StyleAttribute.BREAKWORD, this.styleClassResolver);
                }
                if (breakWord.booleanValue()) {
                    end = visibleEnd == idx ? idx + 1 : visibleEnd;
                } else {
                    while (end < textEnd && !TextArea.isBreak(text.charAt(end))) {
                        ++end;
                    }
                    while (end < textEnd && TextArea.isPunctuation(text.charAt(end))) {
                        ++end;
                    }
                }
                advancePastFloaters = true;
            }
            if (idx < end) {
                LText lt = new LText(te, fontData, text, idx, end, box.doCacheText);
                if (advancePastFloaters) {
                    box.advancePastFloaters(lt.width, box.marginLeft, box.marginRight);
                }
                if (box.textAlignment == TextAreaModel.HAlignment.JUSTIFY && box.getRemaining() < lt.width) {
                    box.nextLine(false);
                }
                int width = lt.width;
                if (end < textEnd && TextArea.isSkip(text.charAt(end))) {
                    width += font.getSpaceWidth();
                }
                lt.x = box.getXAndAdvance(width);
                lt.marginTop = (short)box.marginTop;
                lt.href = box.href;
                lt.inheritHover = inheritHover;
                box.layout.add(lt);
            }
            for (idx = end; idx < textEnd && TextArea.isSkip(text.charAt(idx)); ++idx) {
            }
        }
        if (!box.isAtStartOfLine() && endsWithSpace) {
            box.curX += font.getSpaceWidth();
        }
    }

    private void layoutTextPre(Box box, TextAreaModel.TextElement te, FontData fontData, String text, int textStart, int textEnd, boolean inheritHover) {
        Font font = fontData.font;
        int idx = textStart;
        while (true) {
            block5: {
                int end;
                block8: {
                    block6: {
                        block7: {
                            if (idx >= textEnd) break block5;
                            if (text.charAt(idx) != '\t') break block6;
                            ++idx;
                            int tabX = box.computeNextTabStop(te.getStyle(), font);
                            if (tabX >= box.lineWidth) break block7;
                            box.curX = tabX;
                            break block6;
                        }
                        if (!box.isAtStartOfLine()) break block5;
                    }
                    int tabIdx = text.indexOf(9, idx);
                    end = textEnd;
                    if (tabIdx >= 0 && tabIdx < textEnd) {
                        end = tabIdx;
                    }
                    if (end <= idx) break block8;
                    int count = font.computeVisibleGlpyhs(text, idx, end, box.getRemaining());
                    if (count == 0 && !box.isAtStartOfLine()) break block5;
                    end = idx + Math.max(1, count);
                    LText lt = new LText(te, fontData, text, idx, end, box.doCacheText);
                    lt.x = box.getXAndAdvance(lt.width);
                    lt.marginTop = (short)box.marginTop;
                    lt.inheritHover = inheritHover;
                    box.layout.add(lt);
                }
                idx = end;
                continue;
            }
            if (idx >= textEnd) break;
            box.nextLine(false);
        }
    }

    private void doMarginTop(Box box, Style style) {
        int marginTop = this.convertToPX0(style, StyleAttribute.MARGIN_TOP, box.boxWidth);
        box.nextLine(false);
        box.advanceToY(box.computeTopPadding(marginTop));
    }

    private void doMarginBottom(Box box, Style style) {
        int marginBottom = this.convertToPX0(style, StyleAttribute.MARGIN_BOTTOM, box.boxWidth);
        box.setMarginBottom(marginBottom);
    }

    private void layoutContainerElement(Box box, TextAreaModel.ContainerElement ce) {
        Style style = ce.getStyle();
        this.doMarginTop(box, style);
        box.addAnchor(ce);
        this.layoutElements(box, ce);
        this.doMarginBottom(box, style);
    }

    private void layoutLinkElement(Box box, TextAreaModel.LinkElement le) {
        String oldHref = box.href;
        box.href = le.getHREF();
        Style style = le.getStyle();
        TextAreaModel.Display display = style.get(StyleAttribute.DISPLAY, this.styleClassResolver);
        if (display == TextAreaModel.Display.BLOCK) {
            this.layoutBlockElement(box, le);
        } else {
            this.layoutContainerElement(box, le);
        }
        box.href = oldHref;
    }

    private void layoutListElement(Box box, TextAreaModel.ListElement le) {
        Style style = le.getStyle();
        this.doMarginTop(box, style);
        Image image = this.selectImage(style, StyleAttribute.LIST_STYLE_IMAGE);
        if (image != null) {
            LImage li = new LImage(le, image);
            li.marginRight = (short)this.convertToPX0(style, StyleAttribute.PADDING_LEFT, box.boxWidth);
            this.layout(box, le, li, TextAreaModel.FloatPosition.LEFT, TextAreaModel.Display.BLOCK);
            int imageHeight = li.height;
            li.height = Short.MAX_VALUE;
            this.layoutElements(box, le);
            li.height = imageHeight;
            box.objLeft.remove(li);
            box.advanceToY(li.bottom());
            box.computePadding();
        } else {
            this.layoutElements(box, le);
            box.nextLine(false);
        }
        this.doMarginBottom(box, style);
    }

    private void layoutOrderedListElement(Box box, TextAreaModel.OrderedListElement ole) {
        int i;
        Style style = ole.getStyle();
        FontData fontData = this.createFontData(style);
        if (fontData == null) {
            return;
        }
        this.doMarginTop(box, style);
        LElement anchor = box.addAnchor(ole);
        int start = Math.max(1, ole.getStart());
        int count = ole.getNumElements();
        OrderedListType type = style.get(StyleAttribute.LIST_STYLE_TYPE, this.styleClassResolver);
        String[] labels = new String[count];
        int maxLabelWidth = this.convertToPX0(style, StyleAttribute.PADDING_LEFT, box.boxWidth);
        for (i = 0; i < count; ++i) {
            labels[i] = type.format(start + i).concat(". ");
            int width = fontData.font.computeTextWidth(labels[i]);
            maxLabelWidth = Math.max(maxLabelWidth, width);
        }
        for (i = 0; i < count; ++i) {
            String label = labels[i];
            TextAreaModel.Element li = ole.getElement(i);
            Style liStyle = li.getStyle();
            this.doMarginTop(box, liStyle);
            LText lt = new LText(ole, fontData, label, 0, label.length(), box.doCacheText);
            int labelWidth = lt.width;
            int labelHeight = lt.height;
            lt.width += this.convertToPX0(liStyle, StyleAttribute.PADDING_LEFT, box.boxWidth);
            this.layout(box, ole, lt, TextAreaModel.FloatPosition.LEFT, TextAreaModel.Display.BLOCK);
            lt.x += Math.max(0, maxLabelWidth - labelWidth);
            lt.height = Short.MAX_VALUE;
            this.layoutElement(box, li);
            lt.height = labelHeight;
            box.objLeft.remove(lt);
            box.advanceToY(lt.bottom());
            box.computePadding();
            this.doMarginBottom(box, liStyle);
        }
        anchor.height = box.curY - anchor.y;
        this.doMarginBottom(box, style);
    }

    private Box layoutBox(LClip clip, int continerWidth, int paddingLeft, int paddingRight, TextAreaModel.ContainerElement ce, String href, boolean doCacheText) {
        Style style = ce.getStyle();
        int paddingTop = this.convertToPX0(style, StyleAttribute.PADDING_TOP, continerWidth);
        int paddingBottom = this.convertToPX0(style, StyleAttribute.PADDING_BOTTOM, continerWidth);
        int marginBottom = this.convertToPX0(style, StyleAttribute.MARGIN_BOTTOM, continerWidth);
        Box box = new Box(clip, paddingLeft, paddingRight, paddingTop, doCacheText);
        box.href = href;
        box.style = style;
        this.layoutElements(box, ce);
        box.finish();
        int contentHeight = box.curY + paddingBottom;
        int boxHeight = Math.max(contentHeight, this.convertToPX(style, StyleAttribute.HEIGHT, contentHeight, contentHeight));
        if (boxHeight > contentHeight) {
            int amount = 0;
            switch (style.get(StyleAttribute.VERTICAL_ALIGNMENT, this.styleClassResolver)) {
                case BOTTOM: {
                    amount = boxHeight - contentHeight;
                    break;
                }
                case FILL: 
                case MIDDLE: {
                    amount = (boxHeight - contentHeight) / 2;
                }
            }
            if (amount > 0) {
                clip.moveContentY(amount);
            }
        }
        clip.height = boxHeight;
        clip.marginBottom = (short)Math.max(marginBottom, box.marginBottomAbs - box.curY);
        return box;
    }

    private void layoutBlockElement(Box box, TextAreaModel.ContainerElement be) {
        int bgWidth;
        box.nextLine(false);
        Style style = be.getStyle();
        TextAreaModel.FloatPosition floatPosition = style.get(StyleAttribute.FLOAT_POSITION, this.styleClassResolver);
        LImage bgImage = this.createBGImage(box, be);
        int marginTop = this.convertToPX0(style, StyleAttribute.MARGIN_TOP, box.boxWidth);
        int marginLeft = this.convertToPX0(style, StyleAttribute.MARGIN_LEFT, box.boxWidth);
        int marginRight = this.convertToPX0(style, StyleAttribute.MARGIN_RIGHT, box.boxWidth);
        int bgX = box.computeLeftPadding(marginLeft);
        int bgY = box.computeTopPadding(marginTop);
        int remaining = Math.max(0, box.computeRightPadding(marginRight) - bgX);
        int paddingLeft = this.convertToPX0(style, StyleAttribute.PADDING_LEFT, box.boxWidth);
        int paddingRight = this.convertToPX0(style, StyleAttribute.PADDING_RIGHT, box.boxWidth);
        if (floatPosition == TextAreaModel.FloatPosition.NONE) {
            bgWidth = this.convertToPX(style, StyleAttribute.WIDTH, remaining, remaining);
        } else {
            bgWidth = this.convertToPX(style, StyleAttribute.WIDTH, box.boxWidth, Integer.MIN_VALUE);
            if (bgWidth == Integer.MIN_VALUE) {
                LClip dummy = new LClip(null);
                dummy.width = Math.max(0, box.lineWidth - paddingLeft - paddingRight);
                Box dummyBox = this.layoutBox(dummy, box.boxWidth, paddingLeft, paddingRight, be, null, false);
                dummyBox.nextLine(false);
                bgWidth = Math.max(0, dummy.width - dummyBox.minRemainingWidth);
            }
        }
        bgWidth = Math.max(0, bgWidth) + paddingLeft + paddingRight;
        if (floatPosition != TextAreaModel.FloatPosition.NONE) {
            box.advancePastFloaters(bgWidth, marginLeft, marginRight);
            bgX = box.computeLeftPadding(marginLeft);
            bgY = Math.max(bgY, box.curY);
            remaining = Math.max(0, box.computeRightPadding(marginRight) - bgX);
        }
        bgWidth = Math.min(bgWidth, remaining);
        if (floatPosition == TextAreaModel.FloatPosition.RIGHT) {
            bgX = box.computeRightPadding(marginRight) - bgWidth;
        }
        LClip clip = new LClip(be);
        clip.x = bgX;
        clip.y = bgY;
        clip.width = bgWidth;
        clip.marginLeft = (short)marginLeft;
        clip.marginRight = (short)marginRight;
        clip.href = box.href;
        box.layout.add(clip);
        Box clipBox = this.layoutBox(clip, box.boxWidth, paddingLeft, paddingRight, be, box.href, box.doCacheText);
        box.lineStartIdx = box.layout.size();
        if (floatPosition == TextAreaModel.FloatPosition.NONE) {
            box.advanceToY(bgY + clip.height);
            box.setMarginBottom(clip.marginBottom);
            box.accountMinRemaining(clipBox.minRemainingWidth);
        } else {
            if (floatPosition == TextAreaModel.FloatPosition.RIGHT) {
                box.objRight.add(clip);
            } else {
                box.objLeft.add(clip);
            }
            box.computePadding();
        }
        if (bgImage != null) {
            bgImage.x = bgX;
            bgImage.y = bgY;
            bgImage.width = bgWidth;
            bgImage.height = clip.height;
            bgImage.hoverSrc = clip;
        }
    }

    private void computeTableWidth(TextAreaModel.TableElement te, int maxTableWidth, int[] columnWidth, int[] columnSpacing, boolean[] columnsWithFixedWidth) {
        int numColumns = te.getNumColumns();
        int numRows = te.getNumRows();
        int cellSpacing = te.getCellSpacing();
        int cellPadding = te.getCellPadding();
        HashMap<Integer, Integer> colspanWidths = null;
        for (int col = 0; col < numColumns; ++col) {
            int width = 0;
            int marginLeft = 0;
            int marginRight = 0;
            boolean hasFixedWidth = false;
            for (int row = 0; row < numRows; ++row) {
                TextAreaModel.TableCellElement cell = te.getCell(row, col);
                if (cell == null) continue;
                Style cellStyle = cell.getStyle();
                int colspan = cell.getColspan();
                int cellWidth = this.convertToPX(cellStyle, StyleAttribute.WIDTH, maxTableWidth, Integer.MIN_VALUE);
                if (!(cellWidth != Integer.MIN_VALUE || colspan <= 1 && hasFixedWidth)) {
                    int paddingLeft = Math.max(cellPadding, this.convertToPX0(cellStyle, StyleAttribute.PADDING_LEFT, maxTableWidth));
                    int paddingRight = Math.max(cellPadding, this.convertToPX0(cellStyle, StyleAttribute.PADDING_RIGHT, maxTableWidth));
                    LClip dummy = new LClip(null);
                    dummy.width = maxTableWidth;
                    Box dummyBox = this.layoutBox(dummy, maxTableWidth, paddingLeft, paddingRight, cell, null, false);
                    dummyBox.finish();
                    cellWidth = maxTableWidth - dummyBox.minRemainingWidth;
                } else if (colspan == 1 && cellWidth >= 0) {
                    hasFixedWidth = true;
                }
                if (colspan > 1) {
                    Integer key;
                    Integer value;
                    if (colspanWidths == null) {
                        colspanWidths = new HashMap<Integer, Integer>();
                    }
                    if ((value = (Integer)colspanWidths.get(key = Integer.valueOf((col << 16) + colspan))) != null && cellWidth <= value) continue;
                    colspanWidths.put(key, cellWidth);
                    continue;
                }
                width = Math.max(width, cellWidth);
                marginLeft = Math.max(marginLeft, this.convertToPX(cellStyle, StyleAttribute.MARGIN_LEFT, maxTableWidth, 0));
                marginRight = Math.max(marginRight, this.convertToPX(cellStyle, StyleAttribute.MARGIN_LEFT, maxTableWidth, 0));
            }
            columnsWithFixedWidth[col] = hasFixedWidth;
            columnWidth[col] = width;
            columnSpacing[col] = Math.max(columnSpacing[col], marginLeft);
            columnSpacing[col + 1] = Math.max(cellSpacing, marginRight);
        }
        if (colspanWidths != null) {
            for (Map.Entry e : colspanWidths.entrySet()) {
                int i;
                int key = (Integer)e.getKey();
                int col = key >>> 16;
                int colspan = key & 0xFFFF;
                int width = (Integer)e.getValue();
                int remainingCols = colspan;
                for (i = 0; i < colspan; ++i) {
                    if (!columnsWithFixedWidth[col + i]) continue;
                    width -= columnWidth[col + i];
                    --remainingCols;
                }
                if (width <= 0) continue;
                for (i = 0; i < colspan && remainingCols > 0; ++i) {
                    if (columnsWithFixedWidth[col + i]) continue;
                    int colWidth = width / remainingCols;
                    columnWidth[col + i] = Math.max(columnWidth[col + i], colWidth);
                    width -= colWidth;
                    --remainingCols;
                }
            }
        }
    }

    private void layoutTableElement(Box box, TextAreaModel.TableElement te) {
        int availableColumnWidth;
        boolean autoTableWidth;
        int numColumns = te.getNumColumns();
        int numRows = te.getNumRows();
        int cellSpacing = te.getCellSpacing();
        int cellPadding = te.getCellPadding();
        Style tableStyle = te.getStyle();
        if (numColumns == 0 || numRows == 0) {
            return;
        }
        this.doMarginTop(box, tableStyle);
        LElement anchor = box.addAnchor(te);
        int left = box.computeLeftPadding(this.convertToPX0(tableStyle, StyleAttribute.MARGIN_LEFT, box.boxWidth));
        int right = box.computeRightPadding(this.convertToPX0(tableStyle, StyleAttribute.MARGIN_RIGHT, box.boxWidth));
        int maxTableWidth = Math.max(0, right - left);
        int tableWidth = Math.min(maxTableWidth, this.convertToPX(tableStyle, StyleAttribute.WIDTH, box.boxWidth, Integer.MIN_VALUE));
        boolean bl = autoTableWidth = tableWidth == Integer.MIN_VALUE;
        if (tableWidth <= 0) {
            tableWidth = maxTableWidth;
        }
        int[] columnWidth = new int[numColumns];
        int[] columnSpacing = new int[numColumns + 1];
        boolean[] columnsWithFixedWidth = new boolean[numColumns];
        columnSpacing[0] = Math.max(cellSpacing, this.convertToPX0(tableStyle, StyleAttribute.PADDING_LEFT, box.boxWidth));
        this.computeTableWidth(te, tableWidth, columnWidth, columnSpacing, columnsWithFixedWidth);
        columnSpacing[numColumns] = Math.max(columnSpacing[numColumns], this.convertToPX0(tableStyle, StyleAttribute.PADDING_RIGHT, box.boxWidth));
        int columnSpacingSum = 0;
        for (int spacing : columnSpacing) {
            columnSpacingSum += spacing;
        }
        int columnWidthSum = 0;
        for (int width : columnWidth) {
            columnWidthSum += width;
        }
        if (autoTableWidth) {
            tableWidth = Math.min(maxTableWidth, columnWidthSum + columnSpacingSum);
        }
        if ((availableColumnWidth = Math.max(0, tableWidth - columnSpacingSum)) != columnWidthSum && columnWidthSum > 0) {
            int available = availableColumnWidth;
            int toDistribute = columnWidthSum;
            int remainingCols = numColumns;
            for (int col = 0; col < numColumns; ++col) {
                if (!columnsWithFixedWidth[col]) continue;
                int width = columnWidth[col];
                available -= width;
                toDistribute -= width;
                --remainingCols;
            }
            boolean allColumns = false;
            if (availableColumnWidth < 0) {
                available = availableColumnWidth;
                toDistribute = columnWidthSum;
                remainingCols = numColumns;
                allColumns = true;
            }
            for (int col = 0; col < numColumns && remainingCols > 0; ++col) {
                int newWidth;
                if (!allColumns && columnsWithFixedWidth[col]) continue;
                int width = columnWidth[col];
                columnWidth[col] = newWidth = toDistribute > 0 ? width * available / toDistribute : 0;
                available -= newWidth;
                toDistribute -= width;
            }
        }
        LImage tableBGImage = this.createBGImage(box, te);
        box.textAlignment = TextAreaModel.HAlignment.LEFT;
        box.curY += Math.max(cellSpacing, this.convertToPX0(tableStyle, StyleAttribute.PADDING_TOP, box.boxWidth));
        LImage[] bgImages = new LImage[numColumns];
        for (int row = 0; row < numRows; ++row) {
            int col;
            if (row > 0) {
                box.curY += cellSpacing;
            }
            LImage rowBGImage = null;
            Style rowStyle = te.getRowStyle(row);
            if (rowStyle != null) {
                int marginTop = this.convertToPX0(rowStyle, StyleAttribute.MARGIN_TOP, tableWidth);
                box.curY = box.computeTopPadding(marginTop);
                Image image = this.selectImage(rowStyle, StyleAttribute.BACKGROUND_IMAGE);
                if (image != null) {
                    rowBGImage = new LImage(te, image);
                    rowBGImage.y = box.curY;
                    rowBGImage.x = left;
                    rowBGImage.width = tableWidth;
                    box.clip.bgImages.add(rowBGImage);
                }
                box.curY += this.convertToPX0(rowStyle, StyleAttribute.PADDING_TOP, tableWidth);
                box.minLineHeight = this.convertToPX0(rowStyle, StyleAttribute.HEIGHT, tableWidth);
            }
            int x = left;
            for (col = 0; col < numColumns; ++col) {
                x += columnSpacing[col];
                TextAreaModel.TableCellElement cell = te.getCell(row, col);
                int width = columnWidth[col];
                if (cell != null) {
                    for (int c = 1; c < cell.getColspan(); ++c) {
                        width += columnSpacing[col + c] + columnWidth[col + c];
                    }
                    Style cellStyle = cell.getStyle();
                    int paddingLeft = Math.max(cellPadding, this.convertToPX0(cellStyle, StyleAttribute.PADDING_LEFT, tableWidth));
                    int paddingRight = Math.max(cellPadding, this.convertToPX0(cellStyle, StyleAttribute.PADDING_RIGHT, tableWidth));
                    LClip clip = new LClip(cell);
                    LImage bgImage = this.createBGImage(box, cell);
                    if (bgImage != null) {
                        bgImage.x = x;
                        bgImage.width = width;
                        bgImage.hoverSrc = clip;
                        bgImages[col] = bgImage;
                    }
                    clip.x = x;
                    clip.y = box.curY;
                    clip.width = width;
                    clip.marginTop = (short)this.convertToPX0(cellStyle, StyleAttribute.MARGIN_TOP, tableWidth);
                    box.layout.add(clip);
                    this.layoutBox(clip, tableWidth, paddingLeft, paddingRight, cell, null, box.doCacheText);
                    col += Math.max(0, cell.getColspan() - 1);
                }
                x += width;
            }
            box.nextLine(false);
            for (col = 0; col < numColumns; ++col) {
                LImage bgImage = bgImages[col];
                if (bgImage == null) continue;
                bgImage.height = box.curY - bgImage.y;
                bgImages[col] = null;
            }
            if (rowStyle == null) continue;
            box.curY += this.convertToPX0(rowStyle, StyleAttribute.PADDING_BOTTOM, tableWidth);
            if (rowBGImage != null) {
                rowBGImage.height = box.curY - rowBGImage.y;
            }
            this.doMarginBottom(box, rowStyle);
        }
        box.curY += Math.max(cellSpacing, this.convertToPX0(tableStyle, StyleAttribute.PADDING_BOTTOM, box.boxWidth));
        box.checkFloaters();
        box.accountMinRemaining(Math.max(0, box.lineWidth - tableWidth));
        if (tableBGImage != null) {
            tableBGImage.height = box.curY - tableBGImage.y;
            tableBGImage.x = left;
            tableBGImage.width = tableWidth;
        }
        anchor.x = left;
        anchor.width = tableWidth;
        anchor.height = box.curY - anchor.y;
        this.doMarginBottom(box, tableStyle);
    }

    private LImage createBGImage(Box box, TextAreaModel.Element element) {
        Style style = element.getStyle();
        Image image = this.selectImage(style, StyleAttribute.BACKGROUND_IMAGE);
        if (image == null) {
            image = this.createBackgroundColor(style);
        }
        if (image != null) {
            LImage bgImage = new LImage(element, image);
            bgImage.y = box.curY;
            box.clip.bgImages.add(bgImage);
            return bgImage;
        }
        return null;
    }

    private Image createBackgroundColor(Style style) {
        Image white;
        Color color = style.get(StyleAttribute.BACKGROUND_COLOR, this.styleClassResolver);
        if (color.getAlpha() != 0 && (white = this.selectImage("white")) != null) {
            Image image = white.createTintedVersion(color);
            Color colorHover = style.get(StyleAttribute.BACKGROUND_COLOR_HOVER, this.styleClassResolver);
            if (colorHover != null) {
                return new StateSelectImage(HOVER_STATESELECT, null, white.createTintedVersion(colorHover), image);
            }
            return image;
        }
        return null;
    }

    static boolean isSkip(char ch) {
        return Character.isWhitespace(ch);
    }

    static boolean isPunctuation(char ch) {
        return ":;,.-!?".indexOf(ch) >= 0;
    }

    static boolean isBreak(char ch) {
        return Character.isWhitespace(ch) || TextArea.isPunctuation(ch) || ch == '\u3001' || ch == '\u3002';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LClip
    extends LElement {
        final ArrayList<LElement> layout = new ArrayList();
        final ArrayList<LImage> bgImages = new ArrayList();
        final ArrayList<LElement> anchors = new ArrayList();
        char[] lineInfo = EMPTY_CHAR_ARRAY;

        LClip(TextAreaModel.Element element) {
            super(element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void draw(RenderInfo ri) {
            ri.offsetX += this.x;
            ri.offsetY += this.y;
            ri.renderer.clipEnter(ri.offsetX, ri.offsetY, this.width, this.height);
            try {
                if (!ri.renderer.clipIsEmpty()) {
                    ArrayList<LElement> ll = this.layout;
                    int n = ll.size();
                    for (int i = 0; i < n; ++i) {
                        ll.get(i).draw(ri);
                    }
                }
            }
            finally {
                ri.renderer.clipLeave();
                ri.offsetX -= this.x;
                ri.offsetY -= this.y;
            }
        }

        @Override
        void adjustWidget(int offX, int offY) {
            offX += this.x;
            offY += this.y;
            int n = this.layout.size();
            for (int i = 0; i < n; ++i) {
                this.layout.get(i).adjustWidget(offX, offY);
            }
        }

        @Override
        void collectBGImages(int offX, int offY, ArrayList<LImage> allBGImages) {
            int i;
            offX += this.x;
            offY += this.y;
            int n = this.bgImages.size();
            for (i = 0; i < n; ++i) {
                LImage img = this.bgImages.get(i);
                img.x += offX;
                img.y += offY;
                allBGImages.add(img);
            }
            n = this.layout.size();
            for (i = 0; i < n; ++i) {
                this.layout.get(i).collectBGImages(offX, offY, allBGImages);
            }
        }

        @Override
        void destroy() {
            int n = this.layout.size();
            for (int i = 0; i < n; ++i) {
                this.layout.get(i).destroy();
            }
            this.layout.clear();
            this.bgImages.clear();
            this.lineInfo = EMPTY_CHAR_ARRAY;
        }

        @Override
        LElement find(int x, int y) {
            x -= this.x;
            y -= this.y;
            int lineTop = 0;
            int layoutIdx = 0;
            int lineIdx = 0;
            while (lineIdx < this.lineInfo.length && y >= lineTop) {
                int layoutCount;
                int lineBottom = this.lineInfo[lineIdx++];
                if ((layoutCount = this.lineInfo[lineIdx++]) > 0) {
                    if (lineBottom == 0 || y < lineBottom) {
                        for (int i = 0; i < layoutCount; ++i) {
                            LElement le = this.layout.get(layoutIdx + i);
                            if (!le.isInside(x, y)) continue;
                            return le.find(x, y);
                        }
                        if (lineBottom > 0 && x >= this.layout.get((int)layoutIdx).x) {
                            LElement prev = null;
                            for (int i = 0; i < layoutCount; ++i) {
                                LElement le = this.layout.get(layoutIdx + i);
                                if (le.x >= x && (prev == null || prev.element == le.element)) {
                                    return le;
                                }
                                prev = le;
                            }
                        }
                    }
                    layoutIdx += layoutCount;
                }
                if (lineBottom <= 0) continue;
                lineTop = lineBottom;
            }
            return this;
        }

        @Override
        LElement find(TextAreaModel.Element element, int[] offset) {
            if (this.element == element) {
                return this;
            }
            LElement match = this.find(this.layout, element, offset);
            if (match == null) {
                match = this.find(this.anchors, element, offset);
            }
            return match;
        }

        private LElement find(ArrayList<LElement> l, TextAreaModel.Element e, int[] offset) {
            int n = l.size();
            for (int i = 0; i < n; ++i) {
                LElement match = l.get(i).find(e, offset);
                if (match == null) continue;
                if (offset != null) {
                    offset[0] = offset[0] + this.x;
                    offset[1] = offset[1] + this.y;
                }
                return match;
            }
            return null;
        }

        @Override
        boolean setHover(LElement le) {
            int i;
            boolean childHover = false;
            int n = this.layout.size();
            for (i = 0; i < n; ++i) {
                childHover |= this.layout.get(i).setHover(le);
            }
            if (childHover) {
                this.isHover = true;
            } else {
                super.setHover(le);
            }
            n = this.layout.size();
            for (i = 0; i < n; ++i) {
                LElement child = this.layout.get(i);
                if (!child.inheritHover) continue;
                child.isHover = this.isHover;
            }
            return this.isHover;
        }

        void moveContentY(int amount) {
            int n = this.layout.size();
            for (int i = 0; i < n; ++i) {
                this.layout.get((int)i).y += amount;
            }
            if (this.lineInfo.length > 0) {
                if (this.lineInfo[1] == '\u0000') {
                    this.lineInfo[0] = (char)(this.lineInfo[0] + amount);
                } else {
                    int n2 = this.lineInfo.length;
                    char[] tmpLineInfo = new char[n2 + 2];
                    tmpLineInfo[0] = (char)amount;
                    for (int i = 0; i < n2; i += 2) {
                        int lineBottom = this.lineInfo[i];
                        if (lineBottom > 0) {
                            lineBottom += amount;
                        }
                        tmpLineInfo[i + 2] = (char)lineBottom;
                        tmpLineInfo[i + 3] = this.lineInfo[i + 1];
                    }
                    this.lineInfo = tmpLineInfo;
                }
            }
        }
    }

    static class LImage
    extends LElement {
        final Image img;
        LElement hoverSrc;

        LImage(TextAreaModel.Element element, Image img) {
            super(element);
            this.img = img;
            this.width = img.getWidth();
            this.height = img.getHeight();
            this.hoverSrc = this;
        }

        void draw(RenderInfo ri) {
            this.img.draw(ri.getAnimationState(this.hoverSrc.isHover), this.x + ri.offsetX, this.y + ri.offsetY, this.width, this.height);
        }
    }

    static class LWidget
    extends LElement {
        final Widget widget;

        LWidget(TextAreaModel.Element element, Widget widget) {
            super(element);
            this.widget = widget;
        }

        void adjustWidget(int offX, int offY) {
            this.widget.setPosition(this.x + offX, this.y + offY);
            this.widget.setSize(this.width, this.height);
        }
    }

    static class LText
    extends LElement {
        final FontData fontData;
        final String text;
        final int start;
        final int end;
        FontCache cache;

        LText(TextAreaModel.Element element, FontData fontData, String text, int start, int end, boolean doCache) {
            super(element);
            Font font = fontData.font;
            this.fontData = fontData;
            this.text = text;
            this.start = start;
            this.end = end;
            this.cache = doCache ? font.cacheText(null, text, start, end) : null;
            this.height = font.getLineHeight();
            this.width = this.cache != null ? this.cache.getWidth() : font.computeTextWidth(text, start, end);
        }

        void draw(RenderInfo ri) {
            Color c = this.fontData.getColor(this.isHover);
            if (c != null) {
                this.drawTextWithColor(ri, c);
            } else {
                this.drawText(ri);
            }
        }

        private void drawTextWithColor(RenderInfo ri, Color c) {
            ri.renderer.pushGlobalTintColor(c.getRedFloat(), c.getGreenFloat(), c.getBlueFloat(), c.getAlphaFloat());
            this.drawText(ri);
            ri.renderer.popGlobalTintColor();
        }

        private void drawText(RenderInfo ri) {
            AnimationState as = ri.getAnimationState(this.isHover);
            if (this.cache != null) {
                this.cache.draw(as, this.x + ri.offsetX, this.y + ri.offsetY);
            } else {
                this.fontData.font.drawText(as, this.x + ri.offsetX, this.y + ri.offsetY, this.text, this.start, this.end);
            }
        }

        void destroy() {
            if (this.cache != null) {
                this.cache.destroy();
                this.cache = null;
            }
        }
    }

    static class FontData {
        final Font font;
        final Color color;
        final Color colorHover;

        FontData(Font font, Color color, Color colorHover) {
            if (colorHover == null) {
                colorHover = color;
            }
            this.font = font;
            this.color = FontData.maskWhite(color);
            this.colorHover = FontData.maskWhite(colorHover);
        }

        public Color getColor(boolean isHover) {
            return isHover ? this.colorHover : this.color;
        }

        private static Color maskWhite(Color c) {
            return Color.WHITE.equals(c) ? null : c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LElement {
        final TextAreaModel.Element element;
        int x;
        int y;
        int width;
        int height;
        short marginTop;
        short marginLeft;
        short marginRight;
        short marginBottom;
        String href;
        boolean isHover;
        boolean inheritHover;

        LElement(TextAreaModel.Element element) {
            this.element = element;
        }

        void adjustWidget(int offX, int offY) {
        }

        void collectBGImages(int offX, int offY, ArrayList<LImage> allBGImages) {
        }

        void draw(RenderInfo ri) {
        }

        void destroy() {
        }

        boolean isInside(int x, int y) {
            return x >= this.x && x < this.x + this.width && y >= this.y && y < this.y + this.height;
        }

        LElement find(int x, int y) {
            return this;
        }

        LElement find(TextAreaModel.Element element, int[] offset) {
            if (this.element == element) {
                return this;
            }
            return null;
        }

        boolean setHover(LElement le) {
            this.isHover = this == le || le != null && this.element == le.element;
            return this.isHover;
        }

        int bottom() {
            return this.y + this.height + this.marginBottom;
        }
    }

    static class RenderInfo {
        int offsetX;
        int offsetY;
        Renderer renderer;
        final AnimationState asNormal;
        final AnimationState asHover;

        RenderInfo(AnimationState parent) {
            this.asNormal = new AnimationState(parent);
            this.asNormal.setAnimationState(STATE_HOVER, false);
            this.asHover = new AnimationState(parent);
            this.asHover.setAnimationState(STATE_HOVER, true);
        }

        AnimationState getAnimationState(boolean isHover) {
            return isHover ? this.asHover : this.asNormal;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Box {
        final LClip clip;
        final ArrayList<LElement> layout;
        final ArrayList<LElement> objLeft = new ArrayList();
        final ArrayList<LElement> objRight = new ArrayList();
        final StringBuilder lineInfo = new StringBuilder();
        final int boxLeft;
        final int boxWidth;
        final int boxMarginOffsetLeft;
        final int boxMarginOffsetRight;
        final boolean doCacheText;
        int curY;
        int curX;
        int lineStartIdx;
        int lastProcessedAnchorIdx;
        int marginTop;
        int marginLeft;
        int marginRight;
        int marginBottomAbs;
        int marginBottomNext;
        int lineStartX;
        int lineWidth;
        int fontLineHeight;
        int minLineHeight;
        int lastLineEnd;
        int lastLineBottom;
        int minRemainingWidth;
        boolean inParagraph;
        boolean wasAutoBreak;
        boolean wasPreformatted;
        TextAreaModel.HAlignment textAlignment;
        String href;
        Style style;

        Box(LClip clip, int paddingLeft, int paddingRight, int paddingTop, boolean doCacheText) {
            this.clip = clip;
            this.layout = clip.layout;
            this.boxLeft = paddingLeft;
            this.boxWidth = Math.max(0, clip.width - paddingLeft - paddingRight);
            this.boxMarginOffsetLeft = paddingLeft;
            this.boxMarginOffsetRight = paddingRight;
            this.doCacheText = doCacheText;
            this.curX = paddingLeft;
            this.curY = paddingTop;
            this.lineStartX = paddingLeft;
            this.lineWidth = this.boxWidth;
            this.minRemainingWidth = this.boxWidth;
            this.textAlignment = TextAreaModel.HAlignment.LEFT;
            assert (this.layout.isEmpty());
        }

        void computePadding() {
            int left = this.computeLeftPadding(this.marginLeft);
            int right = this.computeRightPadding(this.marginRight);
            this.lineStartX = left;
            this.lineWidth = Math.max(0, right - left);
            if (this.isAtStartOfLine()) {
                this.curX = this.lineStartX;
            }
            this.accountMinRemaining(this.getRemaining());
        }

        int computeLeftPadding(int marginLeft) {
            int left = this.boxLeft + Math.max(0, marginLeft - this.boxMarginOffsetLeft);
            int n = this.objLeft.size();
            for (int i = 0; i < n; ++i) {
                LElement e = this.objLeft.get(i);
                left = Math.max(left, e.x + e.width + Math.max(e.marginRight, marginLeft));
            }
            return left;
        }

        int computeRightPadding(int marginRight) {
            int right = this.boxLeft + this.boxWidth - Math.max(0, marginRight - this.boxMarginOffsetRight);
            int n = this.objRight.size();
            for (int i = 0; i < n; ++i) {
                LElement e = this.objRight.get(i);
                right = Math.min(right, e.x - Math.max(e.marginLeft, marginRight));
            }
            return right;
        }

        int computePaddingWidth(int marginLeft, int marginRight) {
            return Math.max(0, this.computeRightPadding(marginRight) - this.computeLeftPadding(marginLeft));
        }

        int computeTopPadding(int marginTop) {
            return Math.max(this.marginBottomAbs, this.curY + marginTop);
        }

        void setMarginBottom(int marginBottom) {
            if (this.isAtStartOfLine()) {
                this.marginBottomAbs = Math.max(this.marginBottomAbs, this.curY + marginBottom);
            } else {
                this.marginBottomNext = Math.max(this.marginBottomNext, marginBottom);
            }
        }

        int getRemaining() {
            return Math.max(0, this.lineWidth - this.curX + this.lineStartX);
        }

        void accountMinRemaining(int remaining) {
            this.minRemainingWidth = Math.min(this.minRemainingWidth, remaining);
        }

        int getXAndAdvance(int amount) {
            int x = this.curX;
            this.curX = x + amount;
            return x;
        }

        boolean isAtStartOfLine() {
            return this.lineStartIdx == this.layout.size();
        }

        boolean prevOnLineEndsNotWithSpace() {
            int layoutSize = this.layout.size();
            if (this.lineStartIdx < layoutSize) {
                LElement le = this.layout.get(layoutSize - 1);
                if (le instanceof LText) {
                    LText lt = (LText)le;
                    return !TextArea.isSkip(lt.text.charAt(lt.end - 1));
                }
                return true;
            }
            return false;
        }

        void checkFloaters() {
            this.removeObjFromList(this.objLeft);
            this.removeObjFromList(this.objRight);
            this.computePadding();
        }

        void clearFloater(TextAreaModel.Clear clear) {
            if (clear != TextAreaModel.Clear.NONE) {
                LElement le;
                int i;
                int n;
                int targetY = -1;
                if (clear == TextAreaModel.Clear.LEFT || clear == TextAreaModel.Clear.BOTH) {
                    n = this.objLeft.size();
                    for (i = 0; i < n; ++i) {
                        le = this.objLeft.get(i);
                        if (le.height == Short.MAX_VALUE) continue;
                        targetY = Math.max(targetY, le.y + le.height);
                    }
                }
                if (clear == TextAreaModel.Clear.RIGHT || clear == TextAreaModel.Clear.BOTH) {
                    n = this.objRight.size();
                    for (i = 0; i < n; ++i) {
                        le = this.objRight.get(i);
                        targetY = Math.max(targetY, le.y + le.height);
                    }
                }
                if (targetY >= 0) {
                    this.advanceToY(targetY);
                }
            }
        }

        void advanceToY(int targetY) {
            this.nextLine(false);
            if (targetY > this.curY) {
                this.curY = targetY;
                this.checkFloaters();
            }
        }

        void advancePastFloaters(int requiredWidth, int marginLeft, int marginRight) {
            if (this.computePaddingWidth(marginLeft, marginRight) < requiredWidth) {
                this.nextLine(false);
                do {
                    LElement le;
                    int targetY = Integer.MAX_VALUE;
                    if (!this.objLeft.isEmpty()) {
                        le = this.objLeft.get(this.objLeft.size() - 1);
                        if (le.height != Short.MAX_VALUE) {
                            targetY = Math.min(targetY, le.bottom());
                        }
                    }
                    if (!this.objRight.isEmpty()) {
                        le = this.objRight.get(this.objRight.size() - 1);
                        targetY = Math.min(targetY, le.bottom());
                    }
                    if (targetY == Integer.MAX_VALUE || targetY < this.curY) {
                        return;
                    }
                    this.curY = targetY;
                    this.checkFloaters();
                } while (this.computePaddingWidth(marginLeft, marginRight) < requiredWidth);
            }
        }

        boolean nextLine(boolean force) {
            if (this.isAtStartOfLine() && (this.wasAutoBreak || !force)) {
                return false;
            }
            this.accountMinRemaining(this.getRemaining());
            int targetY = this.curY;
            int lineHeight = this.minLineHeight;
            if (this.isAtStartOfLine()) {
                lineHeight = Math.max(lineHeight, this.fontLineHeight);
            } else {
                int idx;
                for (int idx2 = this.lineStartIdx; idx2 < this.layout.size(); ++idx2) {
                    LElement le = this.layout.get(idx2);
                    lineHeight = Math.max(lineHeight, le.height);
                }
                LElement lastElement = this.layout.get(this.layout.size() - 1);
                int remaining = this.lineStartX + this.lineWidth - (lastElement.x + lastElement.width);
                switch (this.textAlignment) {
                    case RIGHT: {
                        for (idx = this.lineStartIdx; idx < this.layout.size(); ++idx) {
                            LElement le = this.layout.get(idx);
                            le.x += remaining;
                        }
                        break;
                    }
                    case CENTER: {
                        LElement le;
                        int offset = remaining / 2;
                        for (int idx3 = this.lineStartIdx; idx3 < this.layout.size(); ++idx3) {
                            le = this.layout.get(idx3);
                            le.x += offset;
                        }
                        break;
                    }
                    case JUSTIFY: {
                        LElement le;
                        if (remaining >= this.lineWidth / 4) break;
                        int num = this.layout.size() - this.lineStartIdx;
                        for (int i = 1; i < num; ++i) {
                            le = this.layout.get(this.lineStartIdx + i);
                            int offset = remaining * i / (num - 1);
                            le.x += offset;
                        }
                        break;
                    }
                }
                for (idx = this.lineStartIdx; idx < this.layout.size(); ++idx) {
                    LElement le = this.layout.get(idx);
                    switch (le.element.getStyle().get(StyleAttribute.VERTICAL_ALIGNMENT, TextArea.this.styleClassResolver)) {
                        case BOTTOM: {
                            le.y = lineHeight - le.height;
                            break;
                        }
                        case TOP: {
                            le.y = 0;
                            break;
                        }
                        case MIDDLE: {
                            le.y = (lineHeight - le.height) / 2;
                            break;
                        }
                        case FILL: {
                            le.y = 0;
                            le.height = lineHeight;
                        }
                    }
                    targetY = Math.max(targetY, this.computeTopPadding(le.marginTop - le.y));
                    this.marginBottomNext = Math.max(this.marginBottomNext, le.bottom() - lineHeight);
                }
                for (idx = this.lineStartIdx; idx < this.layout.size(); ++idx) {
                    LElement le = this.layout.get(idx);
                    le.y += targetY;
                }
            }
            this.processAnchors(targetY, lineHeight);
            this.minLineHeight = 0;
            this.lineStartIdx = this.layout.size();
            this.wasAutoBreak = !force;
            this.curY = targetY + lineHeight;
            this.marginBottomAbs = Math.max(this.marginBottomAbs, this.curY + this.marginBottomNext);
            this.marginBottomNext = 0;
            this.marginTop = 0;
            this.checkFloaters();
            return true;
        }

        void finish() {
            this.nextLine(false);
            this.clearFloater(TextAreaModel.Clear.BOTH);
            this.processAnchors(this.curY, 0);
            int lineInfoLength = this.lineInfo.length();
            this.clip.lineInfo = new char[lineInfoLength];
            this.lineInfo.getChars(0, lineInfoLength, this.clip.lineInfo, 0);
        }

        int computeNextTabStop(Style style, Font font) {
            int em = font.getEM();
            int tabSize = style.get(StyleAttribute.TAB_SIZE, TextArea.this.styleClassResolver);
            if (tabSize <= 0 || em <= 0) {
                return this.curX + font.getSpaceWidth();
            }
            int tabSizePX = Math.min(tabSize, Short.MAX_VALUE / em) * em;
            int x = this.curX - this.lineStartX + font.getSpaceWidth();
            return this.curX + tabSizePX - x % tabSizePX;
        }

        private void removeObjFromList(ArrayList<LElement> list) {
            int i = list.size();
            while (i-- > 0) {
                LElement e = list.get(i);
                if (e.bottom() > this.curY) continue;
                list.remove(i);
            }
        }

        void setupTextParams(Style style, Font font, boolean isParagraphStart) {
            this.fontLineHeight = font != null ? font.getLineHeight() : 0;
            if (isParagraphStart) {
                this.nextLine(false);
                this.inParagraph = true;
            }
            if (isParagraphStart || !this.inParagraph && this.isAtStartOfLine()) {
                this.marginLeft = TextArea.this.convertToPX0(style, StyleAttribute.MARGIN_LEFT, this.boxWidth);
                this.marginRight = TextArea.this.convertToPX0(style, StyleAttribute.MARGIN_RIGHT, this.boxWidth);
                this.textAlignment = style.get(StyleAttribute.HORIZONTAL_ALIGNMENT, TextArea.this.styleClassResolver);
                this.computePadding();
                this.curX = Math.max(0, this.lineStartX + TextArea.this.convertToPX(style, StyleAttribute.TEXT_INDENT, this.boxWidth, 0));
            }
            this.marginTop = TextArea.this.convertToPX0(style, StyleAttribute.MARGIN_TOP, this.boxWidth);
        }

        LElement addAnchor(TextAreaModel.Element e) {
            LElement le = new LElement(e);
            le.y = this.curY;
            le.x = this.boxLeft;
            le.width = this.boxWidth;
            this.clip.anchors.add(le);
            return le;
        }

        private void processAnchors(int y, int height) {
            while (this.lastProcessedAnchorIdx < this.clip.anchors.size()) {
                LElement le = this.clip.anchors.get(this.lastProcessedAnchorIdx++);
                if (le.height != 0) continue;
                le.y = y;
                le.height = height;
            }
            if (this.lineStartIdx > this.lastLineEnd) {
                this.lineInfo.append('\u0000').append((char)(this.lineStartIdx - this.lastLineEnd));
            }
            if (y > this.lastLineBottom) {
                this.lineInfo.append((char)y).append('\u0000');
            }
            this.lastLineBottom = y + height;
            this.lineInfo.append((char)this.lastLineBottom).append((char)(this.layout.size() - this.lineStartIdx));
            this.lastLineEnd = this.layout.size();
        }
    }

    private static final class FontMapperCacheEntry {
        final int fontSize;
        final int fontStyle;
        final StringList fontFamilies;
        final TextDecoration tdNormal;
        final TextDecoration tdHover;
        final int hashCode;
        final Font font;
        FontMapperCacheEntry next;

        FontMapperCacheEntry(int fontSize, int fontStyle, StringList fontFamilies, TextDecoration tdNormal, TextDecoration tdHover, int hashCode, Font font) {
            this.fontSize = fontSize;
            this.fontStyle = fontStyle;
            this.fontFamilies = fontFamilies;
            this.tdNormal = tdNormal;
            this.tdHover = tdHover;
            this.hashCode = hashCode;
            this.font = font;
        }
    }

    public static interface Callback2
    extends Callback {
        public void handleMouseButton(Event var1, TextAreaModel.Element var2);
    }

    public static interface Callback {
        public void handleLinkClicked(String var1);
    }

    public static interface ImageResolver {
        public Image resolveImage(String var1);
    }

    public static interface WidgetResolver {
        public Widget resolveWidget(String var1, String var2);
    }
}

