/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.ListModel;
import de.matthiasmann.twl.utils.CallbackSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListModel<T>
implements ListModel<T> {
    private ListModel.ChangeListener[] listeners;

    @Override
    public void addChangeListener(ListModel.ChangeListener listener) {
        this.listeners = CallbackSupport.addCallbackToList(this.listeners, listener, ListModel.ChangeListener.class);
    }

    @Override
    public void removeChangeListener(ListModel.ChangeListener listener) {
        this.listeners = CallbackSupport.removeCallbackFromList(this.listeners, listener);
    }

    protected void fireEntriesInserted(int first, int last) {
        if (this.listeners != null) {
            for (ListModel.ChangeListener cl : this.listeners) {
                cl.entriesInserted(first, last);
            }
        }
    }

    protected void fireEntriesDeleted(int first, int last) {
        if (this.listeners != null) {
            for (ListModel.ChangeListener cl : this.listeners) {
                cl.entriesDeleted(first, last);
            }
        }
    }

    protected void fireEntriesChanged(int first, int last) {
        if (this.listeners != null) {
            for (ListModel.ChangeListener cl : this.listeners) {
                cl.entriesChanged(first, last);
            }
        }
    }

    protected void fireAllChanged() {
        if (this.listeners != null) {
            for (ListModel.ChangeListener cl : this.listeners) {
                cl.allChanged();
            }
        }
    }
}

