/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AutoCompletionDataSource;
import de.matthiasmann.twl.model.AutoCompletionResult;
import de.matthiasmann.twl.model.FileSystemModel;
import java.util.ArrayList;

public class FileSystemAutoCompletionDataSource
implements AutoCompletionDataSource {
    final FileSystemModel fsm;
    final FileSystemModel.FileFilter fileFilter;

    public FileSystemAutoCompletionDataSource(FileSystemModel fsm, FileSystemModel.FileFilter fileFilter) {
        if (fsm == null) {
            throw new NullPointerException("fsm");
        }
        this.fsm = fsm;
        this.fileFilter = fileFilter;
    }

    public FileSystemModel getFileSystemModel() {
        return this.fsm;
    }

    public FileSystemModel.FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public AutoCompletionResult collectSuggestions(String text, int cursorPos, AutoCompletionResult prev) {
        text = text.substring(0, cursorPos);
        int prefixLength = this.computePrefixLength(text);
        String prefix = text.substring(0, prefixLength);
        Object parent = prev instanceof Result && prev.getPrefixLength() == prefixLength && prev.getText().startsWith(prefix) ? ((Result)prev).parent : this.fsm.getFile(prefix);
        if (parent == null) {
            return null;
        }
        Result result = new Result(text, prefixLength, parent);
        this.fsm.listFolder(parent, result);
        if (result.getNumResults() == 0) {
            return null;
        }
        return result;
    }

    int computePrefixLength(String text) {
        String separator = this.fsm.getSeparator();
        int prefixLength = text.lastIndexOf(separator) + separator.length();
        if (prefixLength < 0) {
            prefixLength = 0;
        }
        return prefixLength;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Result
    extends AutoCompletionResult
    implements FileSystemModel.FileFilter {
        final Object parent;
        final String nameFilter;
        final ArrayList<String> results1;
        final ArrayList<String> results2;

        public Result(String text, int prefixLength, Object parent) {
            super(text, prefixLength);
            this.results1 = new ArrayList();
            this.results2 = new ArrayList();
            this.parent = parent;
            this.nameFilter = text.substring(prefixLength).toUpperCase();
        }

        @Override
        public boolean accept(FileSystemModel fsm, Object file) {
            int idx;
            FileSystemModel.FileFilter ff = FileSystemAutoCompletionDataSource.this.fileFilter;
            if ((ff == null || ff.accept(fsm, file)) && (idx = this.getMatchIndex(fsm.getName(file))) >= 0) {
                this.addName(fsm.getPath(file), idx);
            }
            return false;
        }

        private int getMatchIndex(String partName) {
            return partName.toUpperCase().indexOf(this.nameFilter);
        }

        private void addName(String fullName, int matchIdx) {
            if (matchIdx == 0) {
                this.results1.add(fullName);
            } else if (matchIdx > 0) {
                this.results2.add(fullName);
            }
        }

        private void addFiltedNames(ArrayList<String> results) {
            int n = results.size();
            for (int i = 0; i < n; ++i) {
                String fullName = results.get(i);
                int idx = this.getMatchIndex(fullName.substring(this.prefixLength));
                this.addName(fullName, idx);
            }
        }

        @Override
        public int getNumResults() {
            return this.results1.size() + this.results2.size();
        }

        @Override
        public String getResult(int idx) {
            int size1 = this.results1.size();
            if (idx >= size1) {
                return this.results2.get(idx - size1);
            }
            return this.results1.get(idx);
        }

        boolean canRefine(String text) {
            return this.prefixLength == FileSystemAutoCompletionDataSource.this.computePrefixLength(text) && text.startsWith(this.text);
        }

        @Override
        public AutoCompletionResult refine(String text, int cursorPos) {
            if (this.canRefine(text = text.substring(0, cursorPos))) {
                Result result = new Result(text, this.prefixLength, this.parent);
                result.addFiltedNames(this.results1);
                result.addFiltedNames(this.results2);
                return result;
            }
            return null;
        }
    }
}

