/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractFloatModel;

public class SimpleFloatModel
extends AbstractFloatModel {
    private final float minValue;
    private final float maxValue;
    private float value;

    public SimpleFloatModel(float minValue, float maxValue, float value) {
        if (Float.isNaN(minValue)) {
            throw new IllegalArgumentException("minValue is NaN");
        }
        if (Float.isNaN(maxValue)) {
            throw new IllegalArgumentException("maxValue is NaN");
        }
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue > maxValue");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = this.limit(value);
    }

    public float getMaxValue() {
        return this.maxValue;
    }

    public float getMinValue() {
        return this.minValue;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        if (this.value != (value = this.limit(value))) {
            this.value = value;
            this.doCallback();
        }
    }

    protected float limit(float value) {
        if (Float.isNaN(value)) {
            return this.minValue;
        }
        return Math.max(this.minValue, Math.min(this.maxValue, value));
    }
}

