/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.model;

import de.matthiasmann.twl.model.AbstractProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProperty<T>
extends AbstractProperty<T> {
    private final Class<T> type;
    private final String name;
    private boolean readOnly;
    private T value;

    public SimpleProperty(Class<T> type, String name, T value) {
        this(type, name, value, false);
    }

    public SimpleProperty(Class<T> type, String name, T value, boolean readOnly) {
        this.type = type;
        this.name = name;
        this.readOnly = readOnly;
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean canBeNull() {
        return false;
    }

    @Override
    public T getPropertyValue() {
        return this.value;
    }

    @Override
    public void setPropertyValue(T value) throws IllegalArgumentException {
        if (value == null && !this.canBeNull()) {
            throw new NullPointerException("value");
        }
        if (this.valueChanged(value)) {
            this.value = value;
            this.fireValueChangedCallback();
        }
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    protected boolean valueChanged(T newValue) {
        return this.value != newValue && (this.value == null || !this.value.equals(newValue));
    }
}

