/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.textarea;

import de.matthiasmann.twl.model.HasCallback;
import de.matthiasmann.twl.textarea.Style;
import de.matthiasmann.twl.textarea.StyleAttribute;
import de.matthiasmann.twl.textarea.TextAreaModel;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTextAreaModel
extends HasCallback
implements TextAreaModel {
    private Style style = new Style();
    private TextAreaModel.Element element;

    public SimpleTextAreaModel() {
    }

    public SimpleTextAreaModel(String text) {
        this();
        this.setText(text);
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        if (style == null) {
            throw new NullPointerException("style");
        }
        this.style = style;
    }

    public void setText(String text) {
        this.setText(text, true);
    }

    public void setText(String text, boolean preformatted) {
        Style textstyle = this.style.with(StyleAttribute.PREFORMATTED, preformatted);
        this.element = new TextAreaModel.TextElement(textstyle, text);
        this.doCallback();
    }

    @Override
    public Iterator<TextAreaModel.Element> iterator() {
        return (this.element != null ? Collections.singletonList(this.element) : Collections.emptyList()).iterator();
    }
}

