/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.theme;

import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.DebugHook;
import de.matthiasmann.twl.ParameterList;
import de.matthiasmann.twl.ParameterMap;
import de.matthiasmann.twl.renderer.Font;
import de.matthiasmann.twl.renderer.Image;
import de.matthiasmann.twl.renderer.MouseCursor;
import de.matthiasmann.twl.theme.ImageManager;
import de.matthiasmann.twl.theme.ThemeChildImpl;
import de.matthiasmann.twl.theme.ThemeInfoImpl;
import de.matthiasmann.twl.theme.ThemeManager;
import de.matthiasmann.twl.utils.CascadedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterMapImpl
extends ThemeChildImpl
implements ParameterMap {
    private final CascadedHashMap<String, Object> params = new CascadedHashMap();
    private static final Class<?>[] BASE_CLASSES = new Class[]{Image.class, Font.class, MouseCursor.class};

    ParameterMapImpl(ThemeManager manager, ThemeInfoImpl parent) {
        super(manager, parent);
    }

    void copy(ParameterMapImpl src) {
        this.params.collapseAndSetFallback(src.params);
    }

    @Override
    public Font getFont(String name) {
        Font value = this.getParameterValue(name, true, Font.class);
        if (value != null) {
            return value;
        }
        return this.manager.getDefaultFont();
    }

    @Override
    public Image getImage(String name) {
        Image img = this.getParameterValue(name, true, Image.class);
        if (img == ImageManager.NONE) {
            return null;
        }
        return img;
    }

    @Override
    public MouseCursor getMouseCursor(String name) {
        MouseCursor value = this.getParameterValue(name, false, MouseCursor.class);
        return value;
    }

    @Override
    public ParameterMap getParameterMap(String name) {
        ParameterMap value = this.getParameterValue(name, true, ParameterMap.class);
        if (value == null) {
            return this.manager.emptyMap;
        }
        return value;
    }

    @Override
    public ParameterList getParameterList(String name) {
        ParameterList value = this.getParameterValue(name, true, ParameterList.class);
        if (value == null) {
            return this.manager.emptyList;
        }
        return value;
    }

    @Override
    public boolean getParameter(String name, boolean defaultValue) {
        Boolean value = this.getParameterValue(name, true, Boolean.class);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public int getParameter(String name, int defaultValue) {
        Integer value = this.getParameterValue(name, true, Integer.class);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public float getParameter(String name, float defaultValue) {
        Float value = this.getParameterValue(name, true, Float.class);
        if (value != null) {
            return value.floatValue();
        }
        return defaultValue;
    }

    @Override
    public String getParameter(String name, String defaultValue) {
        String value = this.getParameterValue(name, true, String.class);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Color getParameter(String name, Color defaultValue) {
        Color value = this.getParameterValue(name, true, Color.class);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public <E extends Enum<E>> E getParameter(String name, E defaultValue) {
        Class<E> enumType = defaultValue.getDeclaringClass();
        Enum value = (Enum)this.getParameterValue(name, true, enumType);
        if (value != null) {
            return (E)value;
        }
        return defaultValue;
    }

    @Override
    public Object getParameterValue(String name, boolean warnIfNotPresent) {
        Object value = this.params.get(name);
        if (value == null && warnIfNotPresent) {
            this.missingParameter(name, null);
        }
        return value;
    }

    @Override
    public <T> T getParameterValue(String name, boolean warnIfNotPresent, Class<T> clazz) {
        return this.getParameterValue(name, warnIfNotPresent, clazz, null);
    }

    @Override
    public <T> T getParameterValue(String name, boolean warnIfNotPresent, Class<T> clazz, T defaultValue) {
        Object value = this.params.get(name);
        if (value == null && warnIfNotPresent) {
            this.missingParameter(name, clazz);
        }
        if (!clazz.isInstance(value)) {
            if (value != null) {
                this.wrongParameterType(name, clazz, value.getClass());
            }
            return defaultValue;
        }
        return clazz.cast(value);
    }

    protected void wrongParameterType(String paramName, Class<?> expectedType, Class<?> foundType) {
        DebugHook.getDebugHook().wrongParameterType(this, paramName, expectedType, foundType, this.getParentDescription());
    }

    protected void missingParameter(String paramName, Class<?> dataType) {
        DebugHook.getDebugHook().missingParameter(this, paramName, this.getParentDescription(), dataType);
    }

    protected void replacingWithDifferentType(String paramName, Class<?> oldType, Class<?> newType) {
        DebugHook.getDebugHook().replacingWithDifferentType(this, paramName, oldType, newType, this.getParentDescription());
    }

    Object getParam(String name) {
        return this.params.get(name);
    }

    void put(Map<String, ?> params) {
        for (Map.Entry<String, ?> e : params.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    void put(String paramName, Object value) {
        Class<?> newClass;
        Class<?> oldClass;
        Object old = this.params.put(paramName, value);
        if (old != null && value != null && (oldClass = old.getClass()) != (newClass = value.getClass()) && !ParameterMapImpl.areTypesCompatible(oldClass, newClass)) {
            this.replacingWithDifferentType(paramName, oldClass, newClass);
        }
    }

    private static boolean areTypesCompatible(Class<?> classA, Class<?> classB) {
        for (Class<?> clazz : BASE_CLASSES) {
            if (!clazz.isAssignableFrom(classA) || !clazz.isAssignableFrom(classB)) continue;
            return true;
        }
        return false;
    }
}

