/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.AnimationState;
import de.matthiasmann.twl.Color;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Renderer;
import de.matthiasmann.twl.utils.CallbackSupport;

public class TintAnimator {
    private static final float ZERO_EPSILON = 0.001f;
    private static final float ONE_EPSILON = 0.999f;
    private final TimeSource timeSource;
    private final float[] currentTint;
    private int fadeDuration;
    private boolean fadeActive;
    private boolean hasTint;
    private Runnable[] fadeDoneCallbacks;

    public TintAnimator(TimeSource timeSource, Color color) {
        if (timeSource == null) {
            throw new NullPointerException("timeSource");
        }
        if (color == null) {
            throw new NullPointerException("color");
        }
        this.timeSource = timeSource;
        this.currentTint = new float[12];
        this.setColor(color);
    }

    public TintAnimator(GUI gui, Color color) {
        this(new GUITimeSource(gui), color);
    }

    public TintAnimator(Widget owner, Color color) {
        this(new GUITimeSource(owner), color);
    }

    public TintAnimator(TimeSource timeSource) {
        this(timeSource, Color.WHITE);
    }

    public TintAnimator(GUI gui) {
        this(new GUITimeSource(gui));
    }

    public TintAnimator(Widget owner) {
        this(new GUITimeSource(owner));
    }

    public void setColor(Color color) {
        color.getFloats(this.currentTint, 0);
        color.getFloats(this.currentTint, 4);
        this.hasTint = !Color.WHITE.equals(color);
        this.fadeActive = false;
        this.fadeDuration = 0;
        this.timeSource.resetTime();
    }

    public void addFadeDoneCallback(Runnable cb) {
        this.fadeDoneCallbacks = CallbackSupport.addCallbackToList(this.fadeDoneCallbacks, cb, Runnable.class);
    }

    public void removeFadeDoneCallback(Runnable cb) {
        this.fadeDoneCallbacks = CallbackSupport.removeCallbackFromList(this.fadeDoneCallbacks, cb);
    }

    public void fadeTo(Color color, int fadeDuration) {
        if (fadeDuration <= 0) {
            this.setColor(color);
        } else {
            color.getFloats(this.currentTint, 8);
            System.arraycopy(this.currentTint, 0, this.currentTint, 4, 4);
            this.fadeActive = true;
            this.fadeDuration = fadeDuration;
            this.hasTint = true;
            this.timeSource.resetTime();
        }
    }

    public void fadeToHide(int fadeDuration) {
        if (fadeDuration <= 0) {
            this.currentTint[3] = 0.0f;
            this.fadeActive = false;
            this.fadeDuration = 0;
            this.hasTint = true;
        } else {
            System.arraycopy(this.currentTint, 0, this.currentTint, 4, 8);
            this.currentTint[11] = 0.0f;
            this.fadeActive = !this.isZeroAlpha();
            this.fadeDuration = fadeDuration;
            this.hasTint = true;
            this.timeSource.resetTime();
        }
    }

    public void update() {
        if (this.fadeActive) {
            int time = this.timeSource.getTime();
            float t = (float)Math.min(time, this.fadeDuration) / (float)this.fadeDuration;
            float tm1 = 1.0f - t;
            float[] tint = this.currentTint;
            for (int i = 0; i < 4; ++i) {
                tint[i] = tm1 * tint[i + 4] + t * tint[i + 8];
            }
            if (time >= this.fadeDuration) {
                this.fadeActive = false;
                this.hasTint = this.currentTint[0] < 0.999f || this.currentTint[1] < 0.999f || this.currentTint[2] < 0.999f || this.currentTint[3] < 0.999f;
                CallbackSupport.fireCallbacks(this.fadeDoneCallbacks);
            }
        }
    }

    public boolean isFadeActive() {
        return this.fadeActive;
    }

    public boolean hasTint() {
        return this.hasTint;
    }

    public boolean isZeroAlpha() {
        return this.currentTint[3] <= 0.001f;
    }

    public void paintWithTint(Renderer renderer) {
        float[] tint = this.currentTint;
        renderer.pushGlobalTintColor(tint[0], tint[1], tint[2], tint[3]);
    }

    public static class AnimationStateTimeSource
    implements TimeSource {
        private final AnimationState animState;
        private final AnimationState.StateKey animStateKey;

        public AnimationStateTimeSource(AnimationState animState, String animStateName) {
            this(animState, AnimationState.StateKey.get(animStateName));
        }

        public AnimationStateTimeSource(AnimationState animState, AnimationState.StateKey animStateKey) {
            if (animState == null) {
                throw new NullPointerException("animState");
            }
            if (animStateKey == null) {
                throw new NullPointerException("animStateKey");
            }
            this.animState = animState;
            this.animStateKey = animStateKey;
        }

        public int getTime() {
            return this.animState.getAnimationTime(this.animStateKey);
        }

        public void resetTime() {
            this.animState.resetAnimationTime(this.animStateKey);
        }
    }

    public static final class GUITimeSource
    implements TimeSource {
        private final Widget owner;
        private final GUI gui;
        private long startTime;
        private boolean pendingReset;

        public GUITimeSource(Widget owner) {
            if (owner == null) {
                throw new NullPointerException("owner");
            }
            this.owner = owner;
            this.gui = null;
            this.resetTime();
        }

        public GUITimeSource(GUI gui) {
            if (gui == null) {
                throw new NullPointerException("gui");
            }
            this.owner = null;
            this.gui = gui;
        }

        public int getTime() {
            GUI g = this.getGUI();
            if (g != null) {
                if (this.pendingReset) {
                    this.pendingReset = false;
                    this.startTime = g.getCurrentTime();
                }
                return (int)(g.getCurrentTime() - this.startTime) & Integer.MAX_VALUE;
            }
            return 0;
        }

        public void resetTime() {
            GUI g = this.getGUI();
            if (g != null) {
                this.startTime = g.getCurrentTime();
                this.pendingReset = false;
            } else {
                this.pendingReset = true;
            }
        }

        private GUI getGUI() {
            return this.gui != null ? this.gui : this.owner.getGUI();
        }
    }

    public static interface TimeSource {
        public void resetTime();

        public int getTime();
    }
}

