/*
 * Decompiled with CFR 0.152.
 */
package de.matthiasmann.twl.utils;

import de.matthiasmann.twl.utils.HashEntry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMapping<V> {
    Entry<V>[] table = new Entry[16];
    int size;

    public void put(Class<?> clazz, V value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.removeCached();
        Entry entry = (Entry)HashEntry.get((HashEntry[])this.table, clazz);
        if (entry != null) {
            HashEntry.remove((HashEntry[])this.table, (HashEntry)entry);
            --this.size;
        }
        this.insert(new Entry<V>(clazz, value, false));
    }

    public V get(Class<?> clazz) {
        Entry entry = (Entry)HashEntry.get((HashEntry[])this.table, clazz);
        if (entry != null) {
            return entry.value;
        }
        return this.slowGet(clazz);
    }

    public boolean remove(Class<?> clazz) {
        if (HashEntry.remove((HashEntry[])this.table, clazz) != null) {
            this.removeCached();
            --this.size;
            return true;
        }
        return false;
    }

    public Set<V> getUniqueValues() {
        HashSet result = new HashSet();
        Entry<V>[] arr$ = this.table;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (Entry e = arr$[i$]; e != null; e = (Entry)e.next()) {
                if (e.isCache) continue;
                result.add(e.value);
            }
        }
        return result;
    }

    public Map<Class<?>, V> getEntries() {
        HashMap result = new HashMap();
        Entry<V>[] arr$ = this.table;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            for (Entry e = arr$[i$]; e != null; e = (Entry)e.next()) {
                if (e.isCache) continue;
                result.put(e.key, e.value);
            }
        }
        return result;
    }

    private V slowGet(Class<?> clazz) {
        Entry entry = null;
        Class<?> baseClass = clazz;
        block0: do {
            for (Class<?> ifClass : baseClass.getInterfaces()) {
                entry = (Entry)HashEntry.get((HashEntry[])this.table, ifClass);
                if (entry != null) break block0;
            }
        } while ((baseClass = baseClass.getSuperclass()) != null && (entry = (Entry)HashEntry.get((HashEntry[])this.table, baseClass)) == null);
        V value = entry != null ? (V)entry.value : null;
        this.insert(new Entry<Object>(clazz, value, true));
        return value;
    }

    private void insert(Entry<V> newEntry) {
        this.table = (Entry[])HashEntry.maybeResizeTable((HashEntry[])this.table, (int)this.size);
        HashEntry.insertEntry((HashEntry[])this.table, newEntry);
        ++this.size;
    }

    /*
     * WARNING - void declaration
     */
    private void removeCached() {
        for (Entry<V> entry : this.table) {
            void var4_4;
            while (var4_4 != null) {
                Entry n = (Entry)var4_4.next();
                if (var4_4.isCache) {
                    HashEntry.remove((HashEntry[])this.table, (HashEntry)var4_4);
                    --this.size;
                }
                Entry entry2 = n;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<V>
    extends HashEntry<Class<?>, Entry<V>> {
        final V value;
        final boolean isCache;

        public Entry(Class<?> key, V value, boolean isCache) {
            super(key);
            this.value = value;
            this.isCache = isCache;
        }
    }
}

