/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.assets.core;

import de.ti2010.mars.assets.core.Asset;
import de.ti2010.mars.assets.core.AssetException;
import de.ti2010.mars.assets.io.AssetDescriptor;
import de.ti2010.mars.assets.io.AssetLoader;
import de.ti2010.mars.io.Source;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Composite
implements Asset<AssetDescriptor>,
Iterable<Asset> {
    private Map<String, Asset> assets;
    private String name;

    public Composite() {
        this("composite");
    }

    public Composite(String string) {
        this.name = string;
        this.assets = new HashMap<String, Asset>();
    }

    public void add(Asset asset) {
        this.assets.put(asset.getName(), asset);
    }

    public void remove(Asset asset) {
        this.assets.remove(asset.getName());
    }

    public Asset get(int n) {
        return (Asset)((List)this.assets.values()).get(n);
    }

    public Asset get(String string) {
        return this.assets.get(string);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Source getSource() {
        throw new AssetException("Illegal call of getSource() due to a composite does not have a source!");
    }

    public void setSource(Source source) {
        throw new AssetException("Illegal call of setSource() due to a composite does not have a source!");
    }

    @Override
    public void load(AssetLoader assetLoader) {
        assetLoader.loadComposite(this);
    }

    @Override
    public Iterator<Asset> iterator() {
        return this.assets.values().iterator();
    }

    @Override
    public AssetDescriptor getDescriptor() {
        return null;
    }
}

