/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.assets.io.pipe.operators;

import de.ti2010.mars.assets.core.Mesh;
import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.assets.io.MeshDescriptor;
import de.ti2010.mars.assets.io.pipe.AbstractPipeOperator;
import de.ti2010.mars.assets.io.pipe.MeshPipe;
import de.ti2010.mars.assets.io.pipe.operators.OperatorException;
import de.ti2010.mars.io.blender.BlenderFile;
import de.ti2010.mars.io.blender.BlenderFileBlock;
import de.ti2010.mars.io.blender.BlenderFileBlockView;
import de.ti2010.mars.io.blender.BlenderFileCatalogue;
import de.ti2010.mars.io.blender.BlenderSource;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.List;

class BlenderSourceMeshLoadOperator
extends AbstractPipeOperator<Mesh, MeshPipe> {
    private FloatBuffer vBuffer;
    private ShortBuffer nBuffer;
    private IntBuffer iBuffer;
    private FloatBuffer uvBuffer;

    public BlenderSourceMeshLoadOperator() {
    }

    public BlenderSourceMeshLoadOperator(AbstractPipeOperator<Mesh, MeshPipe> abstractPipeOperator) {
        super(abstractPipeOperator);
    }

    @Override
    public boolean operate(Mesh mesh, MeshPipe meshPipe) {
        int n;
        int n2;
        BlenderFileBlockView blenderFileBlockView;
        MeshDescriptor meshDescriptor = (MeshDescriptor)mesh.getDescriptor();
        meshDescriptor.setMode(Mesh.Mode.Triangles);
        BlenderFile blenderFile = ((BlenderSource)meshDescriptor.getSource()).getBlenderFile();
        BlenderFileCatalogue blenderFileCatalogue = blenderFile.getCatalogue();
        List<BlenderFileBlock> list = blenderFile.getFileBlocksByIdentifier("OB\u0000\u0000");
        BlenderFileBlockView blenderFileBlockView2 = null;
        for (BlenderFileBlock blenderFileBlock : list) {
            blenderFileBlockView = blenderFileBlock.view();
            blenderFileBlockView.position(blenderFileCatalogue.getStructByName("id").offset("name") + 2);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < 64 && (n2 = (int)blenderFileBlockView.get()) != 0; ++i) {
                stringBuilder.append((char)n2);
            }
            if (!stringBuilder.toString().equals(meshDescriptor.getName())) continue;
            blenderFileBlockView2 = blenderFileBlockView;
            break;
        }
        if (blenderFileBlockView2 == null) {
            throw new OperatorException("Mesh not found in blender file. Unable to find: " + meshDescriptor.getName() + "!");
        }
        blenderFileBlockView2.position(blenderFileCatalogue.getStructByName("Object").offset("data"));
        long l = blenderFileBlockView2.getAddress();
        blenderFileBlockView = blenderFile.getFileBlockByAddress(l).view();
        blenderFileBlockView.position(blenderFileCatalogue.getStructByName("Mesh").offset("mvert"));
        l = blenderFileBlockView.getAddress();
        int n3 = blenderFileBlockView.position(blenderFileCatalogue.getStructByName("Mesh").offset("totvert")).getInt();
        n2 = blenderFileBlockView.position(blenderFileCatalogue.getStructByName("Mesh").offset("totloop")).getInt();
        BlenderFileBlockView blenderFileBlockView3 = blenderFile.getFileBlockByAddress(l).view();
        int n4 = blenderFileCatalogue.getStructByName("MVert").offset("co");
        blenderFileBlockView3.position(n4);
        this.vBuffer = ByteBuffer.allocate((n3 << 2) * 4).asFloatBuffer();
        this.nBuffer = ByteBuffer.allocate((n3 << 1) * 3).asShortBuffer();
        this.iBuffer = ByteBuffer.allocate(n2 << 2).asIntBuffer();
        this.uvBuffer = ByteBuffer.allocate((n2 << 2) * 2).asFloatBuffer();
        for (n = 0; n < n3; ++n) {
            this.vBuffer.put(blenderFileBlockView3.getFloat());
            this.vBuffer.put(blenderFileBlockView3.getFloat());
            this.vBuffer.put(blenderFileBlockView3.getFloat());
            this.vBuffer.put(1.0f);
            this.nBuffer.put(blenderFileBlockView3.getShort());
            this.nBuffer.put(blenderFileBlockView3.getShort());
            this.nBuffer.put(blenderFileBlockView3.getShort());
            blenderFileBlockView3.position(blenderFileBlockView3.position() + 2);
        }
        n = blenderFileBlockView.position(blenderFileCatalogue.getStructByName("Mesh").offset("totPoly")).getInt();
        l = blenderFileBlockView.position(blenderFileCatalogue.getStructByName("Mesh").offset("mpoly")).getAddress();
        BlenderFileBlockView blenderFileBlockView4 = blenderFile.getFileBlockByAddress(l).view();
        l = blenderFileBlockView.position(blenderFileCatalogue.getStructByName("Mesh").offset("mloop")).getAddress();
        BlenderFileBlockView blenderFileBlockView5 = blenderFile.getFileBlockByAddress(l).view();
        l = blenderFileBlockView.position(blenderFileCatalogue.getStructByName("Mesh").offset("mloopuv")).getAddress();
        BlenderFileBlockView blenderFileBlockView6 = blenderFile.getFileBlockByAddress(l).view();
        boolean bl = l != 0L;
        for (int i = 0; i < n; ++i) {
            int n5 = blenderFileBlockView4.getInt();
            int n6 = blenderFileBlockView4.getInt();
            if (n6 != 3) {
                throw new OperatorException("The mesh <" + meshDescriptor.getName() + "> needs to be triangulated!");
            }
            blenderFileBlockView5.position(blenderFileCatalogue.getStructByName("MLoop").size() * n5);
            blenderFileBlockView6.position(blenderFileCatalogue.getStructByName("MLoopUV").size() * n5);
            for (int j = 0; j < n6; ++j) {
                this.iBuffer.put(blenderFileBlockView5.getInt());
                blenderFileBlockView5.getInt();
                if (!bl) continue;
                this.uvBuffer.put(blenderFileBlockView6.getFloat());
                this.uvBuffer.put(blenderFileBlockView6.getFloat());
                blenderFileBlockView6.getInt();
            }
            blenderFileBlockView4.position(blenderFileBlockView4.position() + 4);
        }
        this.vBuffer.flip();
        this.nBuffer.flip();
        this.iBuffer.flip();
        this.uvBuffer.flip();
        meshPipe.setBuffer(this.vBuffer, VertexBuffer.Type.Position);
        meshPipe.setBuffer(this.nBuffer, VertexBuffer.Type.VertexNormal);
        meshPipe.setBuffer(this.iBuffer, VertexBuffer.Type.Index);
        if (bl) {
            meshPipe.setBuffer(this.uvBuffer, VertexBuffer.Type.TexturCoordinate);
        }
        return true;
    }
}

