/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.assets.io.pipe.operators;

import de.ti2010.mars.assets.core.Material;
import de.ti2010.mars.assets.core.Mesh;
import de.ti2010.mars.assets.core.Sound;
import de.ti2010.mars.assets.core.Texture;
import de.ti2010.mars.assets.io.pipe.AbstractPipeOperator;
import de.ti2010.mars.assets.io.pipe.MaterialPipe;
import de.ti2010.mars.assets.io.pipe.MeshPipe;
import de.ti2010.mars.assets.io.pipe.SoundPipe;
import de.ti2010.mars.assets.io.pipe.TexturePipe;
import de.ti2010.mars.assets.io.pipe.operators.BlenderSourceMeshCorrectRotationOperator;
import de.ti2010.mars.assets.io.pipe.operators.BlenderSourceMeshLoadOperator;
import de.ti2010.mars.assets.io.pipe.operators.DefaultPipeOperator;
import de.ti2010.mars.assets.io.pipe.operators.MeshPipeFinalizeOperator;
import de.ti2010.mars.assets.io.pipe.operators.MeshUVCorrectOperator;
import de.ti2010.mars.assets.io.pipe.operators.MeshVerifyOperator;
import de.ti2010.mars.assets.io.pipe.operators.OperatorMappingException;
import de.ti2010.mars.assets.io.pipe.operators.OperatorMappings;
import de.ti2010.mars.assets.io.pipe.operators.PNGTextureDecodeOperator;
import de.ti2010.mars.assets.io.pipe.operators.PNGTextureLoaderOperator;
import de.ti2010.mars.assets.io.pipe.operators.TexturePipeFinalizeOperator;
import de.ti2010.mars.io.Source;
import java.util.HashMap;
import java.util.Map;

public class DefaultOperatorMappings
implements OperatorMappings {
    private static OperatorMappings mapping;
    private DefaultPipeOperator defaultOpeartor = new DefaultPipeOperator();
    private Map<Source.Type, OperatorMappings> mappings = new HashMap<Source.Type, OperatorMappings>();

    private DefaultOperatorMappings() {
        this.mappings.put(Source.Type.BlenderFile, new BlenderFileOperatorMapping());
        this.mappings.put(Source.Type.PNGFile, new PNGFileOperatorMapping());
    }

    @Override
    public AbstractPipeOperator<Mesh, MeshPipe> createMeshPipeOperators(Source source) {
        OperatorMappings operatorMappings = this.mappings.get((Object)source.getType());
        if (operatorMappings == null) {
            throw new OperatorMappingException("No OperatorMapping for the mesh pipe found!");
        }
        return operatorMappings.createMeshPipeOperators(source);
    }

    @Override
    public AbstractPipeOperator<Texture, TexturePipe> createTexturePipeOperators(Source source) {
        OperatorMappings operatorMappings = this.mappings.get((Object)source.getType());
        if (operatorMappings == null) {
            throw new OperatorMappingException("No OperatorMapping the textrue pipe found!");
        }
        return operatorMappings.createTexturePipeOperators(source);
    }

    @Override
    public AbstractPipeOperator<Material, MaterialPipe> createMaterialPipeOperators(Source source) {
        OperatorMappings operatorMappings = this.mappings.get((Object)source.getType());
        if (operatorMappings == null) {
            throw new OperatorMappingException("No OperatorMapping for the material pipe found!");
        }
        return operatorMappings.createMaterialPipeOperators(source);
    }

    @Override
    public AbstractPipeOperator<Sound, SoundPipe> createSoundPipeOperators(Source source) {
        OperatorMappings operatorMappings = this.mappings.get((Object)source.getType());
        if (operatorMappings == null) {
            throw new OperatorMappingException("No OperatorMapping for sound pipe found!");
        }
        return operatorMappings.createSoundPipeOperators(source);
    }

    public static OperatorMappings getInstance() {
        if (mapping == null) {
            mapping = new DefaultOperatorMappings();
        }
        return mapping;
    }

    private class PNGFileOperatorMapping
    implements OperatorMappings {
        private PNGFileOperatorMapping() {
        }

        @Override
        public AbstractPipeOperator<Mesh, MeshPipe> createMeshPipeOperators(Source source) {
            return DefaultOperatorMappings.this.defaultOpeartor;
        }

        @Override
        public AbstractPipeOperator<Texture, TexturePipe> createTexturePipeOperators(Source source) {
            return new PNGTextureLoaderOperator(new PNGTextureDecodeOperator(new TexturePipeFinalizeOperator()));
        }

        @Override
        public AbstractPipeOperator<Material, MaterialPipe> createMaterialPipeOperators(Source source) {
            return DefaultOperatorMappings.this.defaultOpeartor;
        }

        @Override
        public AbstractPipeOperator<Sound, SoundPipe> createSoundPipeOperators(Source source) {
            return DefaultOperatorMappings.this.defaultOpeartor;
        }
    }

    private class BlenderFileOperatorMapping
    implements OperatorMappings {
        private BlenderFileOperatorMapping() {
        }

        @Override
        public AbstractPipeOperator<Mesh, MeshPipe> createMeshPipeOperators(Source source) {
            return new BlenderSourceMeshLoadOperator(new BlenderSourceMeshCorrectRotationOperator(new MeshUVCorrectOperator(new MeshVerifyOperator(new MeshPipeFinalizeOperator()))));
        }

        @Override
        public AbstractPipeOperator<Texture, TexturePipe> createTexturePipeOperators(Source source) {
            return DefaultOperatorMappings.this.defaultOpeartor;
        }

        @Override
        public AbstractPipeOperator<Material, MaterialPipe> createMaterialPipeOperators(Source source) {
            return DefaultOperatorMappings.this.defaultOpeartor;
        }

        @Override
        public AbstractPipeOperator<Sound, SoundPipe> createSoundPipeOperators(Source source) {
            return DefaultOperatorMappings.this.defaultOpeartor;
        }
    }
}

