/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.gl;

import de.ti2010.mars.gfx.gl.GL;
import de.ti2010.mars.gfx.gl.GLDecorator;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.apache.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

class ErrorCheckGL
extends GLDecorator {
    private Logger logger = Logger.getLogger(GL.class);

    public ErrorCheckGL(GL gL) {
        super(gL);
    }

    private void check(String string) {
        int n = GL11.glGetError();
        if (n != 0) {
            this.logger.error((Object)(string + " : " + GLU.gluErrorString((int)n)));
        }
    }

    @Override
    public void glAttachShader(int n, int n2) {
        this.origin.glAttachShader(n, n2);
        this.check("glAttachShader(program=" + n + ", shader=" + n2 + ")");
    }

    @Override
    public void glBindAttribLocation(int n, int n2, ByteBuffer byteBuffer) {
        this.origin.glBindAttribLocation(n, n2, byteBuffer);
        this.check("glBindAttribLocation(program=" + n + ", index=" + n2 + ", name=" + byteBuffer + ")");
    }

    @Override
    public void glBindAttribLocation(int n, int n2, String string) {
        this.origin.glBindAttribLocation(n, n2, string);
        this.check("glBindAttribLocation(program=" + n + ", index=" + n2 + ", name=" + string + ")");
    }

    @Override
    public void glBindBuffer(int n, int n2) {
        this.origin.glBindBuffer(n, n2);
        this.check("glBindBuffer(" + n + ", " + n2 + ")");
    }

    @Override
    public void glBindVertexArray(int n) {
        this.origin.glBindVertexArray(n);
        this.check("glBindVertexArray(" + n + ")");
    }

    @Override
    public void glBufferData(int n, ByteBuffer byteBuffer, int n2) {
        this.origin.glBufferData(n, byteBuffer, n2);
        this.check("glBufferData(" + n + ", " + byteBuffer + ", " + n2 + ")");
    }

    @Override
    public void glBlendFunc(int n, int n2) {
        this.origin.glBlendFunc(n, n2);
        this.check("glBlendFunc(sfactor=" + n + ", dfactor=" + n2);
    }

    @Override
    public void glBufferData(int n, DoubleBuffer doubleBuffer, int n2) {
        this.origin.glBufferData(n, doubleBuffer, n2);
        this.check("glBufferData(" + n + ", " + doubleBuffer + ", " + n2 + ")");
    }

    @Override
    public void glBufferData(int n, FloatBuffer floatBuffer, int n2) {
        this.origin.glBufferData(n, floatBuffer, n2);
        this.check("glBufferData(" + n + ", " + floatBuffer + ", " + n2 + ")");
    }

    @Override
    public void glBufferData(int n, IntBuffer intBuffer, int n2) {
        this.origin.glBufferData(n, intBuffer, n2);
        this.check("glBufferData(" + n + ", " + intBuffer + ", " + n2 + ")");
    }

    @Override
    public void glBufferData(int n, ShortBuffer shortBuffer, int n2) {
        this.origin.glBufferData(n, shortBuffer, n2);
        this.check("glBufferData(" + n + ", " + shortBuffer + ", " + n2 + ")");
    }

    @Override
    public void glBufferData(int n, long l, int n2) {
        this.origin.glBufferData(n, l, n2);
        this.check("glBufferData(" + n + ", " + l + ", " + n2 + ")");
    }

    @Override
    public void glClear(int n) {
        this.origin.glClear(n);
        this.check("glClear(mask=" + n + ")");
    }

    @Override
    public void glClearColor(float f, float f2, float f3, float f4) {
        this.origin.glClearColor(f, f2, f3, f4);
        this.check("glClearColor(red=" + f + ", green=" + f2 + ", blue=" + f3 + ", alpha=" + f4 + ")");
    }

    @Override
    public void glClearDepth(double d) {
        this.origin.glClearDepth(d);
        this.check("glClearDepth(depth=" + d + ")");
    }

    @Override
    public void glCompileShader(int n) {
        this.origin.glCompileShader(n);
        this.check("glCompileShader(shader=" + n + ")");
    }

    @Override
    public int glCreateProgram() {
        int n = this.origin.glCreateProgram();
        this.check("glCreateProgram()\t result: " + n);
        return n;
    }

    @Override
    public int glCreateShader(int n) {
        int n2 = this.origin.glCreateShader(n);
        this.check("glCreateShader()\t result: " + n2);
        return n2;
    }

    @Override
    public void glDeleteBuffers(int n) {
        this.origin.glDeleteBuffers(n);
        this.check("glDeleteBuffers(" + n + ")");
    }

    @Override
    public void glDeleteBuffers(IntBuffer intBuffer) {
        this.origin.glDeleteBuffers(intBuffer);
        this.check("glDeleteBuffers(" + intBuffer + ")");
    }

    @Override
    public void glDepthFunc(int n) {
        this.origin.glDepthFunc(n);
        this.check("glDepthFunc(" + n + ")");
    }

    @Override
    public void glDepthMask(boolean bl) {
        this.origin.glDepthMask(bl);
        this.check("glDepthMask(flag=" + bl + ")");
    }

    @Override
    public void glDepthRange(double d, double d2) {
        this.origin.glDepthRange(d, d2);
        this.check("glDepthRange(zNear=" + d + ", zFar=" + d2 + ")");
    }

    @Override
    public void glDetachShader(int n, int n2) {
        this.origin.glDetachShader(n, n2);
        this.check("glDetachShader(program=" + n + ", shader=" + n2 + ")");
    }

    @Override
    public void glDisable(int n) {
        this.origin.glDisable(n);
        this.check("glDisable(" + n + ")");
    }

    @Override
    public void glDrawArrays(int n, int n2, int n3) {
        this.origin.glDrawArrays(n, n2, n3);
        this.check("glDrawArrays(" + n + ", " + n2 + ", " + n3 + ")");
    }

    @Override
    public void glEnable(int n) {
        this.origin.glEnable(n);
        this.check("glEnable(" + n + ")");
    }

    @Override
    public int glGenBuffers() {
        int n = this.origin.glGenBuffers();
        this.check("glGenBuffers()\t result: " + n);
        return n;
    }

    @Override
    public void glGenBuffers(IntBuffer intBuffer) {
        this.origin.glGenBuffers(intBuffer);
        this.check("glGenBuffers()");
    }

    @Override
    public int glGenVertexArrays() {
        int n = this.origin.glGenVertexArrays();
        this.check("glGenVertexArrays()\t\tresult: " + n);
        return n;
    }

    @Override
    public void glGenVertexArrays(IntBuffer intBuffer) {
        this.origin.glGenVertexArrays(intBuffer);
        this.check("glGenVertexArrays(" + intBuffer + ")");
    }

    @Override
    public int glGetError() {
        int n = this.origin.glGetError();
        this.check("glGetError()\t result:" + n);
        return n;
    }

    @Override
    public int glGetProgram(int n, int n2) {
        int n3 = this.origin.glGetProgram(n, n2);
        this.check("glGetProgram(program=" + n + ", parameterName=" + n2 + ")\t result: " + n3);
        return n3;
    }

    @Override
    public String glGetProgramInfoLog(int n, int n2) {
        String string = this.origin.glGetProgramInfoLog(n, n2);
        this.check("glGetProgramInfoLog(program=" + n + ", maxLength=" + n2 + ")\t result: " + string);
        return string;
    }

    @Override
    public int glGetShader(int n, int n2) {
        int n3 = this.origin.glGetShader(n, n2);
        this.check("glGetShader(shader=" + n + ", parameterName=" + n2 + ")\t result: " + n3);
        return n3;
    }

    @Override
    public String glGetShaderInfoLog(int n, int n2) {
        String string = this.origin.glGetShaderInfoLog(n, n2);
        this.check("glGetShaderInfoLog(shader=" + n + ", maxLength=" + n2 + ")\t result: " + string);
        return string;
    }

    @Override
    public String glGetString(int n) {
        String string = this.origin.glGetString(n);
        this.check("glGetString(" + n + ")\t result: " + string);
        return string;
    }

    @Override
    public void glGetUniform(int n, int n2, FloatBuffer floatBuffer) {
        this.origin.glGetUniform(n, n2, floatBuffer);
        this.check("glGetUniform(program=" + n + ", location=" + n2 + ", params=" + floatBuffer + ")");
    }

    @Override
    public void glGetUniform(int n, int n2, IntBuffer intBuffer) {
        this.origin.glGetUniform(n, n2, intBuffer);
        this.check("glGetUniform(program=" + n + ", location=" + n2 + ", params=" + intBuffer + ")");
    }

    @Override
    public int glGetUniformLocation(int n, ByteBuffer byteBuffer) {
        int n2 = this.origin.glGetUniformLocation(n, byteBuffer);
        this.check("glGetUniformLocation(program=" + n + ", name=" + byteBuffer + ")\t result: " + n2);
        return n2;
    }

    @Override
    public int glGetUniformLocation(int n, CharSequence charSequence) {
        int n2 = this.origin.glGetUniformLocation(n, charSequence);
        this.check("glGetUniformLocation(program=" + n + ", name=" + charSequence + ")\t result: " + n2);
        return n2;
    }

    @Override
    public void glLinkProgram(int n) {
        this.origin.glLinkProgram(n);
        this.check("glLinkProgram(program=" + n + ")");
    }

    @Override
    public void glUniformMatrix4(int n, boolean bl, FloatBuffer floatBuffer) {
        this.origin.glUniformMatrix4(n, bl, floatBuffer);
        this.check("glUniformMatrix4(location=" + n + ", transpose=" + bl + ", matrices=" + floatBuffer);
    }

    @Override
    public void glUniform1(int n, FloatBuffer floatBuffer) {
        this.origin.glUniform1(n, floatBuffer);
        this.check("glUniform1(location=" + n + ", values=" + floatBuffer);
    }

    @Override
    public void glUniform1f(int n, float f) {
        this.origin.glUniform1f(n, f);
        this.check("glUniform1f(location=" + n + ", v0=" + f);
    }

    @Override
    public void glUniform2(int n, FloatBuffer floatBuffer) {
        this.origin.glUniform2(n, floatBuffer);
        this.check("glUniform2(location=" + n + ", values=" + floatBuffer);
    }

    @Override
    public void glUniform2f(int n, float f, float f2) {
        this.origin.glUniform2f(n, f, f2);
        this.check("glUniform2f(location=" + n + ", v0=" + f + ", v1=" + f2);
    }

    @Override
    public void glUniform3(int n, FloatBuffer floatBuffer) {
        this.origin.glUniform3(n, floatBuffer);
        this.check("glUniform3(location=" + n + ", values=" + floatBuffer);
    }

    @Override
    public void glUniform3f(int n, float f, float f2, float f3) {
        this.origin.glUniform3f(n, f, f2, f3);
        this.check("glUniform3f(location=" + n + ", v0=" + f + ", v1=" + f2 + ", v2=" + f3);
    }

    @Override
    public void glUniform4(int n, FloatBuffer floatBuffer) {
        this.origin.glUniform4(n, floatBuffer);
        this.check("glUniform4(location=" + n + ", values=" + floatBuffer);
    }

    @Override
    public void glUniform4f(int n, float f, float f2, float f3, float f4) {
        this.origin.glUniform4f(n, f, f2, f3, f4);
        this.check("glUniform4f(location=" + n + ", v0=" + f + ", v1=" + f2 + ", v2=" + f3 + ", v3=" + f4);
    }

    @Override
    public void glShaderSource(int n, ByteBuffer byteBuffer) {
        this.origin.glShaderSource(n, byteBuffer);
        this.check("glShaderSource(shader=" + n + ", src=" + byteBuffer + ")");
    }

    @Override
    public void glValidateProgram(int n) {
        this.origin.glValidateProgram(n);
        this.check("glValidateProgram(program=" + n + ")");
    }

    @Override
    public void glVertexAttribPointer(int n, int n2, boolean bl, int n3, DoubleBuffer doubleBuffer) {
        this.origin.glVertexAttribPointer(n, n2, bl, n3, doubleBuffer);
        this.check("glVertexAttribPointer(index=" + String.valueOf(n) + ", size=" + String.valueOf(n2) + ", normalized=" + String.valueOf(bl) + ", stride=" + String.valueOf(n3) + ", buffer)");
    }

    @Override
    public void glVertexAttribPointer(int n, int n2, boolean bl, int n3, FloatBuffer floatBuffer) {
        this.origin.glVertexAttribPointer(n, n2, bl, n3, floatBuffer);
        this.check("glVertexAttribPointer(index=" + String.valueOf(n) + ", size=" + String.valueOf(n2) + ", normalized=" + String.valueOf(bl) + ", stride=" + String.valueOf(n3) + ", buffer)");
    }

    @Override
    public void glVertexAttribPointer(int n, int n2, boolean bl, boolean bl2, int n3, ByteBuffer byteBuffer) {
        this.origin.glVertexAttribPointer(n, n2, bl, bl2, n3, byteBuffer);
        this.check("glVertexAttribPointer(index=" + String.valueOf(n) + ", size=" + String.valueOf(n2) + ", unsigned=" + String.valueOf(bl) + ", normalized=" + String.valueOf(bl2) + ", stride=" + String.valueOf(n3) + ", buffer)");
    }

    @Override
    public void glVertexAttribPointer(int n, int n2, boolean bl, boolean bl2, int n3, ShortBuffer shortBuffer) {
        this.origin.glVertexAttribPointer(n, n2, bl, bl2, n3, shortBuffer);
        this.check("glVertexAttribPointer(index=" + String.valueOf(n) + ", size=" + String.valueOf(n2) + ", unsigned=" + String.valueOf(bl) + ", normalized=" + String.valueOf(bl2) + ", stride=" + String.valueOf(n3) + ", buffer)");
    }

    @Override
    public void glVertexAttribPointer(int n, int n2, boolean bl, boolean bl2, int n3, IntBuffer intBuffer) {
        this.origin.glVertexAttribPointer(n, n2, bl, bl2, n3, intBuffer);
        this.check("glVertexAttribPointer(index=" + String.valueOf(n) + ", size=" + String.valueOf(n2) + ", unsigned=" + String.valueOf(bl) + ", normalized=" + String.valueOf(bl2) + ", stride=" + String.valueOf(n3) + ", buffer)");
    }

    @Override
    public void glVertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, int n5) {
        this.origin.glVertexAttribPointer(n, n2, n3, bl, n4, n5);
        this.check("glVertexAttribPointer(index=" + String.valueOf(n) + ", size=" + String.valueOf(n2) + ", type=" + String.valueOf(n3) + ", normalized=" + String.valueOf(bl) + ", stride=" + String.valueOf(n4) + ", offset=" + String.valueOf(n5) + ")");
    }

    @Override
    public void glViewport(int n, int n2, int n3, int n4) {
        this.origin.glViewport(n, n2, n3, n4);
        this.check("glViewport(x=" + n + ", y=" + n2 + ", width=" + n3 + ", height=" + n4 + ")");
    }

    @Override
    public void glDisableVertexAttribArray(int n) {
        this.origin.glDisableVertexAttribArray(n);
        this.check("glDisableVertexAttribArray(" + n + ")");
    }

    @Override
    public void glEnableVertexAttribArray(int n) {
        this.origin.glEnableVertexAttribArray(n);
        this.check("glEnableVertexAttribArray(" + n + ")");
    }

    @Override
    public void glUseProgram(int n) {
        this.origin.glUseProgram(n);
        this.check("glUseProgram(" + n + ")");
    }

    @Override
    public void glDrawElements(int n, ByteBuffer byteBuffer) {
        this.origin.glDrawElements(n, byteBuffer);
        this.check("glDrawElements(" + n + ", " + byteBuffer + ")");
    }

    @Override
    public void glDrawElements(int n, IntBuffer intBuffer) {
        this.origin.glDrawElements(n, intBuffer);
        this.check("glDrawElements(" + n + ", " + intBuffer + ")");
    }

    @Override
    public void glDrawElements(int n, ShortBuffer shortBuffer) {
        this.origin.glDrawElements(n, shortBuffer);
        this.check("glDrawElements(" + n + ", " + shortBuffer + ")");
    }

    @Override
    public void glDrawElements(int n, int n2, int n3, long l) {
        this.origin.glDrawElements(n, n2, n3, l);
        this.check("glDrawElements(" + n + ", " + n2 + ", " + n3 + ", " + l + ")");
    }

    @Override
    public void glPolygonMode(int n, int n2) {
        this.origin.glPolygonMode(n, n2);
        this.check("glPolygonMode(" + n + ", " + n2 + ")");
    }

    @Override
    public void glActiveTexture(int n) {
        this.origin.glActiveTexture(n);
        this.check("glActiveTexture(" + n + ")");
    }

    @Override
    public void glBindTexture(int n, int n2) {
        this.origin.glBindTexture(n, n2);
        this.check("glBindTexture(" + n + ", " + n2 + ")");
    }

    @Override
    public int glGenTextures() {
        int n = this.origin.glGenTextures();
        this.check("glGenTextures(" + n + ")");
        return n;
    }

    @Override
    public void glPixelStorei(int n, int n2) {
        this.origin.glPixelStorei(n, n2);
        this.check("glPixelStorei(" + n + ", " + n2 + ")");
    }

    @Override
    public void glGenerateMipmap(int n) {
        this.origin.glGenerateMipmap(n);
        this.check("glGenerateMipmap(" + n + ")");
    }

    @Override
    public void glTexParameteri(int n, int n2, int n3) {
        this.origin.glTexParameteri(n, n2, n3);
        this.check("glTexParameteri(" + n + ", " + n2 + ", " + n3 + ")");
    }

    @Override
    public void glTexImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ByteBuffer byteBuffer) {
        this.origin.glTexImage2D(n, n2, n3, n4, n5, n6, n7, n8, byteBuffer);
        this.check("glTexImage2D(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ", " + n6 + ", " + n7 + ", " + n8 + ", " + byteBuffer + ")");
    }
}

