/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.renderer;

import de.ti2010.mars.gfx.Vendor;

public class RenderConfiguration {
    private final int DISPLAY_WIDTH = 1024;
    private final int DISPLAY_HEIGHT = 768;
    private final float near_plane = 1.0f;
    private final float far_plane = 100.0f;
    private final float fieldOfView = 30.0f;
    private final float aspectRatio = 1.3333334f;
    private float y_scale = (float)(1.0 / Math.tan(Math.toRadians(15.0)));
    private float x_scale = this.y_scale / 1.3333334f;
    private float frustum_length = 99.0f;
    private final String pathToVertexShaderForColoredRendering = "res/shaders/coloredRendering.vs";
    private final String pathToFragmentShaderForColoredRendering = "res/shaders/coloredRendering.fs";
    private String pathToVertexShaderForTexturedRendering = null;
    private final String pathToFragmentShaderForTexturedRendering = "res/shaders/texturedRendering.fs";

    public void setVendor(Vendor vendor) {
        this.pathToVertexShaderForTexturedRendering = vendor == Vendor.ATI ? "res/shaders/AMD_texturedRendering.vs" : "res/shaders/NV_texturedRendering.vs";
    }

    public int getDisplayWidth() {
        return 1024;
    }

    public int getDisplayHeight() {
        return 768;
    }

    public float getNearPlane() {
        return 1.0f;
    }

    public float getFarPlane() {
        return 100.0f;
    }

    public float getFieldOfView() {
        return 30.0f;
    }

    public float getAspectRatio() {
        return 1.3333334f;
    }

    public String getPathOfVertexShaderColoredRendering() {
        return "res/shaders/coloredRendering.vs";
    }

    public String getPathOfFragmentShaderColoredRendering() {
        return "res/shaders/coloredRendering.fs";
    }

    public String getPathOfVertexShaderTexturedRendering() {
        return this.pathToVertexShaderForTexturedRendering;
    }

    public String getPathOfFragmentShaderTexturedRendering() {
        return "res/shaders/texturedRendering.fs";
    }

    public float getYScale() {
        return this.y_scale;
    }

    public float getXScale() {
        return this.x_scale;
    }

    public float getFrustumLength() {
        return this.frustum_length;
    }
}

