/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.renderer.impl;

import de.ti2010.mars.assets.core.Texture;
import de.ti2010.mars.gfx.Util;
import de.ti2010.mars.gfx.core.NativeUIFrame;
import de.ti2010.mars.gfx.gl.GL;
import de.ti2010.mars.gfx.renderer.RenderConfiguration;
import de.ti2010.mars.gfx.renderer.UIRenderer;
import de.ti2010.mars.gfx.shader.Program;
import de.ti2010.mars.gfx.shader.Shader;

class UIRendererImpl
implements UIRenderer {
    private GL gl;
    private Program program = null;
    private RenderConfiguration configuration = null;

    UIRendererImpl() {
    }

    @Override
    public void initialize(RenderConfiguration renderConfiguration) {
        this.gl = GL.getInstance();
        this.configuration = renderConfiguration;
        this.program = new Program();
        this.program.initialize();
        Shader shader = new Shader();
        shader.initialize(Shader.Type.VertexShader, new Shader.Source("res/shaders/uiRendering.vs"));
        Shader shader2 = new Shader();
        shader2.initialize(Shader.Type.FragmentShader, new Shader.Source("res/shaders/uiRendering.fs"));
        this.program.attach(shader);
        this.program.attach(shader2);
        this.program.link();
        this.program.use();
        float f = renderConfiguration.getDisplayWidth() / 2;
        float f2 = -renderConfiguration.getDisplayWidth() / 2;
        float f3 = renderConfiguration.getDisplayHeight() / 2;
        float f4 = -renderConfiguration.getDisplayHeight() / 2;
        float f5 = 1.0f;
        float f6 = -1.0f;
        this.program.getUniformMatrix4f("projectionMatrix").get().setIdentity();
        this.program.getUniformMatrix4f((String)"projectionMatrix").get().m00 = 2.0f / (f - f2);
        this.program.getUniformMatrix4f((String)"projectionMatrix").get().m11 = 2.0f / (f3 - f4);
        this.program.getUniformMatrix4f((String)"projectionMatrix").get().m22 = -2.0f / (f5 - f6);
        this.program.getUniformMatrix4f((String)"projectionMatrix").get().m03 = -((f + f2) / (f - f2));
        this.program.getUniformMatrix4f((String)"projectionMatrix").get().m13 = -((f3 + f4) / (f3 - f4));
        this.program.getUniformMatrix4f((String)"projectionMatrix").get().m23 = -((f5 + f6) / (f5 - f6));
        this.program.getUniformMatrix4f("projectionMatrix").push();
    }

    @Override
    public void render(NativeUIFrame nativeUIFrame) {
        if (nativeUIFrame == null) {
            return;
        }
        this.gl.glEnable(3042);
        this.program.use();
        nativeUIFrame.repaint();
        nativeUIFrame.bind();
        nativeUIFrame.enable();
        this.gl.glGenerateMipmap(Util.glTexture(Texture.Type.Texture2D));
        this.gl.glDrawElements(4, 6, 5125, 0L);
        nativeUIFrame.disable();
        nativeUIFrame.unbind();
        this.gl.glDisable(3042);
    }
}

