/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.shader;

import de.ti2010.mars.assets.core.VertexBuffer;
import de.ti2010.mars.gfx.core.NativeObject;
import de.ti2010.mars.gfx.gl.GL;
import de.ti2010.mars.gfx.shader.ProgramException;
import de.ti2010.mars.gfx.shader.Shader;
import de.ti2010.mars.gfx.shader.Uniform;
import de.ti2010.mars.gfx.shader.Uniform1f;
import de.ti2010.mars.gfx.shader.Uniform2f;
import de.ti2010.mars.gfx.shader.Uniform3f;
import de.ti2010.mars.gfx.shader.Uniform4f;
import de.ti2010.mars.gfx.shader.UniformException;
import de.ti2010.mars.gfx.shader.UniformMatrix4f;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL11;

public class Program
implements NativeObject {
    private GL gl;
    int handle = -1;
    private boolean isInitialized = false;
    private boolean isLinked = false;
    private Shader[] program = new Shader[VertexBuffer.Type.values().length];
    private Map<String, Uniform> uniforms = new HashMap<String, Uniform>();

    public Program() {
        this.gl = GL.getInstance();
    }

    public void initialize() throws ProgramException {
        if (this.isInitialized()) {
            throw new ProgramException("Shader program has already been initialized!");
        }
        try {
            this.handle = this.gl.glCreateProgram();
            for (VertexBuffer.Type type : VertexBuffer.Type.values()) {
                this.gl.glBindAttribLocation(this.handle, type.ordinal(), "in_" + type.name().toLowerCase());
            }
            this.isInitialized = true;
        }
        catch (Exception exception) {
            throw new ProgramException("Initialization of the shader program failed!", exception);
        }
    }

    public void attach(Shader shader) throws ProgramException {
        if (shader == null) {
            throw new ProgramException("Can not attach null shader!");
        }
        if (!this.isInitialized()) {
            throw new ProgramException("Can not attach to an uninitialize shader program!");
        }
        if (this.isLinked()) {
            throw new ProgramException("Can not attach to an already linked shader program!");
        }
        if (!shader.isInitialized()) {
            throw new ProgramException("Can not attach an uninitialized shader!");
        }
        int n = shader.getType().ordinal();
        if (this.program[n] != null) {
            throw new ProgramException("A " + (Object)((Object)shader.getType()) + " has already been attached!");
        }
        this.program[n] = shader;
        this.gl.glAttachShader(this.handle, shader.handle);
    }

    public void detach(Shader shader) {
        if (!this.isInitialized()) {
            throw new ProgramException("Can not detach from an uninitialize shader program!");
        }
        if (this.isLinked()) {
            throw new ProgramException("Can not detach from an already linked shader program!");
        }
        if (!shader.isInitialized()) {
            throw new ProgramException("Can not detach an uninitialize shader!");
        }
        int n = shader.getType().ordinal();
        if (this.program[n] != null && this.program[n].equals(shader)) {
            this.gl.glDetachShader(this.handle, shader.handle);
            this.program[n] = null;
        }
    }

    public void link() throws ProgramException {
        if (!this.isInitialized()) {
            throw new ProgramException("Can not link an uninitialize shader program!");
        }
        try {
            this.gl.glLinkProgram(this.handle);
        }
        catch (Exception exception) {
            throw new ProgramException("Linking of the shader program failed!", exception);
        }
        if (this.gl.glGetProgram(this.handle, 35714) == 0) {
            String string = this.gl.glGetProgramInfoLog(this.handle, 1337);
            throw new ProgramException("Linking of the shader program failed: " + string);
        }
        this.gl.glValidateProgram(this.handle);
        if (GL11.glGetError() != 0) {
            throw new ProgramException("Program initialization failed!");
        }
        this.isLinked = true;
    }

    public void use() {
        this.gl.glUseProgram(this.handle);
    }

    public Uniform1f getUniform1f(String string) throws ProgramException, UniformException {
        if (!this.isInitialized()) {
            throw new ProgramException("Uninitialized program!");
        }
        Uniform uniform = this.uniforms.get(string);
        if (uniform == null) {
            int n = this.gl.glGetUniformLocation(this.handle, string);
            if (n < 0) {
                throw new ProgramException("Uniform <" + string + "> not found!");
            }
            Uniform1f uniform1f = new Uniform1f(n, string, this);
            this.uniforms.put(uniform1f.getName(), uniform1f);
            return uniform1f;
        }
        return (Uniform1f)uniform;
    }

    public Uniform2f getUniform2f(String string) throws ProgramException, UniformException {
        if (!this.isInitialized()) {
            throw new ProgramException("Uninitialized program!");
        }
        Uniform uniform = this.uniforms.get(string);
        if (uniform == null) {
            int n = this.gl.glGetUniformLocation(this.handle, string);
            if (n < 0) {
                throw new ProgramException("Uniform <" + string + "> not found!");
            }
            Uniform2f uniform2f = new Uniform2f(n, string, this);
            this.uniforms.put(uniform2f.getName(), uniform2f);
            return uniform2f;
        }
        return (Uniform2f)uniform;
    }

    public Uniform3f getUniform3f(String string) throws ProgramException, UniformException {
        if (!this.isInitialized()) {
            throw new ProgramException("Uninitialized program!");
        }
        Uniform uniform = this.uniforms.get(string);
        if (uniform == null) {
            int n = this.gl.glGetUniformLocation(this.handle, string);
            if (n < 0) {
                throw new ProgramException("Uniform <" + string + "> not found!");
            }
            Uniform3f uniform3f = new Uniform3f(n, string, this);
            this.uniforms.put(uniform3f.getName(), uniform3f);
            return uniform3f;
        }
        return (Uniform3f)uniform;
    }

    public Uniform4f getUniform4f(String string) throws ProgramException, UniformException {
        if (!this.isInitialized()) {
            throw new ProgramException("Uninitialized program!");
        }
        Uniform uniform = this.uniforms.get(string);
        if (uniform == null) {
            int n = this.gl.glGetUniformLocation(this.handle, string);
            if (n < 0) {
                throw new ProgramException("Uniform <" + string + "> not found!");
            }
            Uniform4f uniform4f = new Uniform4f(n, string, this);
            this.uniforms.put(uniform4f.getName(), uniform4f);
            return uniform4f;
        }
        return (Uniform4f)uniform;
    }

    public UniformMatrix4f getUniformMatrix4f(String string) throws ProgramException, UniformException {
        if (!this.isInitialized()) {
            throw new ProgramException("Uninitialized program!");
        }
        Uniform uniform = this.uniforms.get(string);
        if (uniform == null) {
            int n = this.gl.glGetUniformLocation(this.handle, string);
            if (n < 0) {
                throw new ProgramException("Uniform <" + string + "> not found!");
            }
            UniformMatrix4f uniformMatrix4f = new UniformMatrix4f(n, string, this);
            this.uniforms.put(uniformMatrix4f.getName(), uniformMatrix4f);
            return uniformMatrix4f;
        }
        return (UniformMatrix4f)uniform;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    @Override
    public void free() {
        throw new UnsupportedOperationException("Program.free()");
    }
}

