/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.gfx.shader;

import de.ti2010.mars.gfx.shader.Program;
import de.ti2010.mars.gfx.shader.Uniform;
import de.ti2010.mars.gfx.shader.UniformException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import javax.vecmath.Vector3f;

public class Uniform3f
extends Uniform<Uniform3f> {
    private Vector3f vector = new Vector3f();
    private FloatBuffer data;

    Uniform3f(int n, String string, Program program) {
        super(n, string, program);
        try {
            this.data = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
        }
        catch (Exception exception) {
            throw new UniformException("Instantiation of the uniform failed!", exception);
        }
    }

    @Override
    public Uniform3f fetch() throws UniformException {
        this.data.clear();
        this.gl.glGetUniform(this.program.handle, this.handle, this.data);
        if (this.gl.glGetError() != 0) {
            throw new UniformException("Fetching the uniform failed!");
        }
        this.data.flip();
        this.vector.x = this.data.get();
        this.vector.y = this.data.get();
        this.vector.z = this.data.get();
        return this;
    }

    @Override
    public Uniform3f push() throws UniformException {
        this.data.clear();
        this.data.put(this.vector.x).put(this.vector.y).put(this.vector.z);
        this.data.flip();
        this.gl.glUniform3(this.handle, this.data);
        if (this.gl.glGetError() != 0) {
            throw new UniformException("Pushing the uniform failed!");
        }
        return this;
    }

    public Vector3f get() {
        return this.vector;
    }
}

