/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.io.blender.impl;

import de.ti2010.mars.io.blender.BlenderFile;
import de.ti2010.mars.io.blender.BlenderFileBlock;
import de.ti2010.mars.io.blender.BlenderFileCatalogue;
import de.ti2010.mars.io.blender.BlenderFileException;
import de.ti2010.mars.io.blender.BlenderFileHeader;
import de.ti2010.mars.io.blender.impl.BlenderFileBlockImpl;
import de.ti2010.mars.io.blender.impl.BlenderFileCatalogueImpl;
import de.ti2010.mars.io.blender.impl.BlenderFileHeaderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class BlenderFileImpl
implements BlenderFile {
    private File file;
    private ByteBuffer buffer;
    private BlenderFileHeaderImpl header = new BlenderFileHeaderImpl();
    private BlenderFileCatalogue catalogue = new BlenderFileCatalogueImpl(this);
    private Map<Long, BlenderFileBlock> fileBlocks = new HashMap<Long, BlenderFileBlock>();

    protected BlenderFileImpl() {
    }

    protected void initialize(File file) throws BlenderFileException {
        Object object;
        this.file = file;
        this.buffer = ByteBuffer.allocate((int)file.length());
        try {
            object = new FileInputStream(file);
            Iterator<BlenderFileBlock> iterator = ((FileInputStream)object).getChannel();
            ((FileChannel)((Object)iterator)).read(this.buffer);
            this.buffer.flip();
            ((AbstractInterruptibleChannel)((Object)iterator)).close();
            ((FileInputStream)object).close();
        }
        catch (IOException iOException) {
            throw new BlenderFileException(iOException);
        }
        this.header.initialize(this.buffer);
        if (this.header.isLittleEndian()) {
            this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
        }
        do {
            object = new BlenderFileBlockImpl(this);
            ((BlenderFileBlockImpl)object).initialize(this.buffer);
            this.fileBlocks.put(object.getAddress(), (BlenderFileBlock)object);
        } while (!object.getIdentifier().equals("ENDB"));
        for (BlenderFileBlock blenderFileBlock : this.fileBlocks.values()) {
            if (!blenderFileBlock.getIdentifier().equals("DNA1")) continue;
            object = blenderFileBlock;
            break;
        }
        if (!object.getIdentifier().equals("DNA1")) {
            object = null;
            for (BlenderFileBlock blenderFileBlock : this.fileBlocks.values()) {
                if (!blenderFileBlock.getIdentifier().equals("DNA1")) continue;
                object = blenderFileBlock;
            }
        }
        if (object == null) {
            throw new BlenderFileException("No DNA1 file block found!");
        }
        ((BlenderFileCatalogueImpl)this.catalogue).initialize((BlenderFileBlock)object);
    }

    @Override
    public BlenderFileHeader getHeader() {
        return this.header;
    }

    ByteBuffer getBuffer() {
        return this.buffer;
    }

    @Override
    public BlenderFileCatalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    public List<BlenderFileBlock> getFileBlocksByIdentifier(String string) {
        ArrayList<BlenderFileBlock> arrayList = new ArrayList<BlenderFileBlock>();
        for (BlenderFileBlock blenderFileBlock : this.fileBlocks.values()) {
            if (!blenderFileBlock.getIdentifier().equals(string)) continue;
            arrayList.add(blenderFileBlock);
        }
        return arrayList;
    }

    @Override
    public BlenderFileBlock getFileBlockByAddress(long l) {
        return this.fileBlocks.get(l);
    }

    public void exportCatalogue(OutputStream outputStream) throws JAXBException {
        JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{BlenderFileCatalogueImpl.class});
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)this.catalogue, outputStream);
    }

    public static BlenderFileImpl open(File file) throws BlenderFileException {
        BlenderFileImpl blenderFileImpl = new BlenderFileImpl();
        blenderFileImpl.initialize(file);
        return blenderFileImpl;
    }
}

