/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.io.png;

import de.ti2010.mars.io.Source;
import de.ti2010.mars.io.SourceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;

public class PNGFileSource
extends Source {
    private FileChannel channel = null;

    public PNGFileSource(String string, URI uRI) {
        super(string, uRI);
    }

    @Override
    public Source open() throws SourceException {
        try {
            this.channel = new FileInputStream(new File(this.uri)).getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new SourceException("Failed to open PNGSource!", fileNotFoundException);
        }
        return this;
    }

    @Override
    public void close() throws SourceException {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            throw new SourceException("Failed to close PNGSource!", iOException);
        }
    }

    @Override
    public Source.Type getType() {
        return Source.Type.PNGFile;
    }

    @Override
    public boolean isOpen() {
        return this.channel != null;
    }

    public FileChannel getFileChannel() {
        return this.channel;
    }
}

