/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.physics.jbullet;

import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import de.ti2010.mars.simulator.PhysicsEntity;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;

public abstract class JBulletAbstractBasicElementRepresentation {
    protected RigidBody rigidBody = null;
    protected MotionState motionState = null;
    protected Vector3f inertia = new Vector3f(0.0f, 0.0f, 0.0f);
    protected CollisionShape collisionShape = null;
    protected RigidBodyConstructionInfo rigidBodyConstructionInfo = null;
    protected float mass = 0.0f;
    protected PhysicsEntity physicsEntity = null;
    private Transform trans = new Transform();

    public JBulletAbstractBasicElementRepresentation(float f, CollisionShape collisionShape, MotionState motionState, RigidBodyConstructionInfo rigidBodyConstructionInfo, RigidBody rigidBody, PhysicsEntity physicsEntity) {
        this.rigidBody = rigidBody;
        this.motionState = motionState;
        this.collisionShape = collisionShape;
        this.rigidBodyConstructionInfo = rigidBodyConstructionInfo;
        this.mass = f;
        this.collisionShape.calculateLocalInertia(f, this.inertia);
        this.physicsEntity = physicsEntity;
    }

    public void setRigidBody(RigidBody rigidBody) {
        this.rigidBody = rigidBody;
    }

    public RigidBody getRigidBody() {
        return this.rigidBody;
    }

    public void setMotionState(MotionState motionState) {
        this.motionState = motionState;
    }

    public MotionState getMotionState() {
        return this.motionState;
    }

    public void setCollisionShape(CollisionShape collisionShape) {
        this.collisionShape = collisionShape;
    }

    public void setRigidBodyConstructionInfo(RigidBodyConstructionInfo rigidBodyConstructionInfo) {
        this.rigidBodyConstructionInfo = rigidBodyConstructionInfo;
    }

    public void translate(Vector3f vector3f) {
        this.rigidBody.translate(vector3f);
    }

    public void notifyChanged() {
        System.out.println("Nicht aufrufbar!!!!!!11111111111elf");
    }

    public Matrix3f getRotationMatrix() {
        this.rigidBody.getMotionState().getWorldTransform(this.trans);
        return this.trans.basis;
    }

    public Vector3f getTranslationMatrix() {
        this.rigidBody.getMotionState().getWorldTransform(this.trans);
        return this.trans.origin;
    }
}

