/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.physics.jbullet;

import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import de.ti2010.mars.physics.core.AbstractElementFactory;
import de.ti2010.mars.physics.core.GroundElement;
import de.ti2010.mars.physics.core.RoverElement;
import de.ti2010.mars.physics.core.StoneElement;
import de.ti2010.mars.physics.jbullet.JBulletGroundElement;
import de.ti2010.mars.physics.jbullet.JBulletRoverElement;
import de.ti2010.mars.physics.jbullet.JBulletStoneElement;
import de.ti2010.mars.simulator.PhysicsEntity;
import javax.vecmath.Vector3f;

public class JBulletElementFactory
extends AbstractElementFactory {
    @Override
    public StoneElement createGenericStoneElement(PhysicsEntity physicsEntity) {
        float f = 1000.0f;
        DefaultMotionState defaultMotionState = new DefaultMotionState();
        BoxShape boxShape = new BoxShape(new Vector3f(1.0f, 1.0f, 1.0f));
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        RigidBodyConstructionInfo rigidBodyConstructionInfo = new RigidBodyConstructionInfo(f, defaultMotionState, boxShape, vector3f);
        RigidBody rigidBody = new RigidBody(rigidBodyConstructionInfo);
        return new JBulletStoneElement(f, boxShape, defaultMotionState, rigidBodyConstructionInfo, rigidBody, physicsEntity);
    }

    @Override
    public GroundElement createGenericGroundElement(PhysicsEntity physicsEntity) {
        float f = 0.0f;
        DefaultMotionState defaultMotionState = new DefaultMotionState();
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        BoxShape boxShape = new BoxShape(new Vector3f(500.0f, 5.0f, 500.0f));
        Transform transform = new Transform();
        ((MotionState)defaultMotionState).getWorldTransform(transform);
        transform.origin.y -= 5.0f;
        ((MotionState)defaultMotionState).setWorldTransform(transform);
        RigidBodyConstructionInfo rigidBodyConstructionInfo = new RigidBodyConstructionInfo(f, defaultMotionState, boxShape, vector3f);
        RigidBody rigidBody = new RigidBody(rigidBodyConstructionInfo);
        rigidBody.setFriction(0.3f);
        return new JBulletGroundElement(f, boxShape, defaultMotionState, rigidBodyConstructionInfo, rigidBody, physicsEntity);
    }

    @Override
    public RoverElement createGenericRoverElement(PhysicsEntity physicsEntity) {
        return new JBulletRoverElement(physicsEntity);
    }
}

