/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.scene;

import de.ti2010.mars.scene.Camera;
import de.ti2010.mars.scene.Node;
import de.ti2010.mars.scene.camera.CameraManager;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

public class CameraNode
extends Node
implements Camera {
    protected Camera origin;
    protected CameraManager camManager;
    protected boolean active = false;
    protected Matrix4f rotXMatrix = new Matrix4f();
    protected Matrix4f rotYMatrix = new Matrix4f();
    protected Matrix4f rotZMatrix = new Matrix4f();
    protected Matrix4f rotMatrix = new Matrix4f();

    public CameraNode(Camera camera, Type type) {
        CameraNode cameraNode;
        switch (type) {
            case FollowerCamera: {
                cameraNode = new FollowerCameraNode(camera);
                break;
            }
            default: {
                cameraNode = new MountedCameraNode(camera);
            }
        }
        this.setCamera(cameraNode);
        this.rotXMatrix.setIdentity();
        this.rotYMatrix.setIdentity();
        this.rotZMatrix.setIdentity();
    }

    protected CameraNode(Camera camera) {
        this.setCamera(camera);
    }

    public void setCamera(Camera camera) {
        this.origin = camera;
        this.camManager = this.origin.getCameraManager();
    }

    public Camera getCamera() {
        return this.origin;
    }

    @Override
    public Matrix4f getViewMatrix() {
        return this.origin.getViewMatrix();
    }

    public void setRotation() {
        this.rotMatrix.setIdentity();
        this.rotYMatrix.mul(this.rotZMatrix);
        this.rotXMatrix.mul(this.rotYMatrix);
        this.rotMatrix.mul(this.rotXMatrix);
        this.setRelativeRotation(this.rotXMatrix);
    }

    @Override
    public CameraManager getCameraManager() {
        return this.origin.getCameraManager();
    }

    @Override
    public void setActive(boolean bl) {
        if (bl) {
            this.active = true;
            this.camManager.activate(this);
        } else {
            this.active = false;
            this.camManager.deactivate(this);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isInvertZ() {
        return this.origin.isInvertZ();
    }

    @Override
    public boolean isInvertX() {
        return this.origin.isInvertX();
    }

    @Override
    public boolean isInvertY() {
        return this.origin.isInvertY();
    }

    @Override
    public void setInvertZ(boolean bl) {
        this.origin.setInvertZ(bl);
    }

    @Override
    public void setInvertX(boolean bl) {
        this.origin.setInvertX(bl);
    }

    @Override
    public void setInvertY(boolean bl) {
        this.origin.setInvertY(bl);
    }

    @Override
    public Vector3f getPosition() {
        return this.origin.getPosition();
    }

    @Override
    public void setPosition(Vector3f vector3f) {
        this.setRelativeTranslation(vector3f);
    }

    @Override
    public void setX(float f) {
        this.origin.setX(f);
    }

    @Override
    public float getX() {
        return this.origin.getX();
    }

    @Override
    public void setY(float f) {
        this.origin.setY(f);
    }

    @Override
    public float getY() {
        return this.origin.getY();
    }

    @Override
    public void setZ(float f) {
        this.origin.setZ(f);
    }

    @Override
    public float getZ() {
        return this.origin.getZ();
    }

    @Override
    public float getYaw() {
        return this.origin.getYaw();
    }

    @Override
    public void setYaw(float f) {
        this.origin.setYaw(f);
        this.rotYMatrix.setIdentity();
        this.rotYMatrix.rotY(this.getYaw());
        this.setRotation();
    }

    @Override
    public float getPitch() {
        return this.origin.getPitch();
    }

    @Override
    public void setPitch(float f) {
        this.origin.setPitch(f);
        this.rotXMatrix.setIdentity();
        this.rotXMatrix.rotX(this.getPitch());
        this.setRotation();
    }

    @Override
    public float getRoll() {
        return this.origin.getRoll();
    }

    @Override
    public void setRoll(float f) {
        this.origin.setRoll(f);
        this.rotZMatrix.setIdentity();
        this.rotZMatrix.rotZ(this.getRoll());
        this.setRotation();
    }

    @Override
    public float getYawOffset() {
        return this.origin.getYawOffset();
    }

    @Override
    public void setYawOffset(float f) {
        this.origin.setYawOffset(f);
        this.setYaw(f);
    }

    @Override
    public float getPitchOffset() {
        return this.origin.getPitchOffset();
    }

    @Override
    public void setPitchOffset(float f) {
        this.origin.setPitchOffset(f);
        this.setPitch(f);
    }

    @Override
    public float getRollOffset() {
        return this.origin.getRollOffset();
    }

    @Override
    public void setRollOffset(float f) {
        this.origin.setRollOffset(f);
        this.setRoll(f);
    }

    @Override
    public Vector3f getCameraOffset() {
        return this.origin.getCameraOffset();
    }

    @Override
    public void setCameraOffset(Vector3f vector3f) {
        this.origin.setCameraOffset(vector3f);
    }

    @Override
    public boolean isNoYawLimit() {
        return this.origin.isNoYawLimit();
    }

    @Override
    public void setNoYawLimit(boolean bl) {
        this.origin.setNoYawLimit(bl);
    }

    @Override
    public boolean isNoPitchLimit() {
        return this.origin.isNoPitchLimit();
    }

    @Override
    public void setNoPitchLimit(boolean bl) {
        this.origin.setNoPitchLimit(bl);
    }

    @Override
    public boolean isNoRollLimit() {
        return this.origin.isNoRollLimit();
    }

    @Override
    public void setNoRollLimit(boolean bl) {
        this.origin.setNoRollLimit(bl);
    }

    @Override
    public float getMinYaw() {
        return this.origin.getMinYaw();
    }

    @Override
    public void setMinYaw(float f) {
        this.origin.setMinYaw(f);
    }

    @Override
    public float getMinPitch() {
        return this.origin.getMinPitch();
    }

    @Override
    public void setMinPitch(float f) {
        this.origin.setMinPitch(f);
    }

    @Override
    public float getMaxYaw() {
        return this.origin.getMaxYaw();
    }

    @Override
    public void setMaxYaw(float f) {
        this.origin.setMaxYaw(f);
    }

    @Override
    public float getMaxPitch() {
        return this.origin.getMaxPitch();
    }

    @Override
    public float getMinRoll() {
        return this.origin.getMinRoll();
    }

    @Override
    public void setMinRoll(float f) {
        this.origin.setMinRoll(f);
    }

    @Override
    public float getMaxRoll() {
        return this.origin.getMaxRoll();
    }

    @Override
    public void setMaxRoll(float f) {
        this.origin.setMaxRoll(f);
    }

    @Override
    public void setMaxPitch(float f) {
        this.origin.setMaxPitch(f);
    }

    @Override
    public float getDistance() {
        return this.origin.getDistance();
    }

    @Override
    public void setDistance(float f) {
        this.origin.setDistance(f);
    }

    @Override
    public float getDistanceChange() {
        return this.origin.getDistanceChange();
    }

    @Override
    public void setDistanceChange(float f) {
        this.origin.setDistanceChange(f);
    }

    @Override
    public float getMinDistance() {
        return this.origin.getMinDistance();
    }

    @Override
    public void setMinDistance(float f) {
        this.origin.setMinDistance(f);
    }

    @Override
    public float getMaxDistance() {
        return this.origin.getMaxDistance();
    }

    @Override
    public void setMaxDistance(float f) {
        this.origin.setMaxDistance(f);
    }

    @Override
    public void increaseDistance() {
        this.origin.increaseDistance();
    }

    @Override
    public void decreaseDistance() {
        this.origin.decreaseDistance();
    }

    @Override
    public float getMouseSensitivity() {
        return this.origin.getMouseSensitivity();
    }

    @Override
    public void setMouseSensitivity(float f) {
        this.origin.setMouseSensitivity(f);
    }

    private class FollowerCameraNode
    extends CameraNode {
        private Matrix4f viewMatrix;
        private Matrix4f translationMatrix;
        private Vector3f posVector;
        private Matrix4f posMatrix;

        public FollowerCameraNode(Camera camera) {
            super(camera);
            this.viewMatrix = new Matrix4f();
            this.translationMatrix = new Matrix4f();
            this.posVector = new Vector3f();
            this.posMatrix = new Matrix4f();
        }

        @Override
        public Matrix4f getViewMatrix() {
            this.viewMatrix.setIdentity();
            this.rotXMatrix.setIdentity();
            this.rotYMatrix.setIdentity();
            this.translationMatrix.setIdentity();
            this.rotXMatrix.setTranslation(new Vector3f(0.0f, 0.0f, this.getDistance()));
            this.rotXMatrix.rotX(this.getPitch());
            this.rotXMatrix.setTranslation(new Vector3f(0.0f, 0.0f, -this.getDistance()));
            this.rotYMatrix.rotY(this.getYaw());
            this.posMatrix = CameraNode.this.getAbsoluteTranslation();
            this.posMatrix.invert();
            this.posMatrix.get(this.posVector);
            this.translationMatrix.setTranslation(this.posVector);
            this.rotXMatrix.mul(this.rotYMatrix);
            this.viewMatrix.mul(this.rotXMatrix, this.translationMatrix);
            return this.viewMatrix;
        }
    }

    private class MountedCameraNode
    extends CameraNode {
        public MountedCameraNode(Camera camera) {
            super(camera);
        }

        @Override
        public Matrix4f getViewMatrix() {
            Matrix4f matrix4f = CameraNode.this.getCumulateMatrix();
            matrix4f.invert();
            return matrix4f;
        }
    }

    public static enum Type {
        MountedCamera,
        FollowerCamera;

    }
}

