/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.scene;

import de.ti2010.mars.scene.GroupNode;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

public abstract class Node {
    private static long LAST_ID = Long.MIN_VALUE;
    private final long id;
    protected String name;
    protected Matrix4f relativeTranslation = new Matrix4f();
    protected Matrix4f relativeRotation = new Matrix4f();
    protected Matrix4f relativeScaling = new Matrix4f();
    protected Matrix4f absoluteTranslation = new Matrix4f();
    protected Matrix4f absoluteRotation = new Matrix4f();
    protected Matrix4f absoluteScaling = new Matrix4f();
    protected Matrix4f cumulate = new Matrix4f();
    private GroupNode parent = null;

    public Node() {
        this("");
    }

    public Node(String string) {
        this.id = LAST_ID++;
        this.relativeTranslation.setIdentity();
        this.relativeRotation.setIdentity();
        this.relativeScaling.setIdentity();
        this.absoluteTranslation.setIdentity();
        this.absoluteRotation.setIdentity();
        this.absoluteScaling.setIdentity();
        this.name = string;
        this.update();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public GroupNode getParent() {
        return this.parent;
    }

    public void setParent(GroupNode groupNode) {
        this.parent = groupNode;
        this.update();
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public Matrix4f getCumulateMatrix() {
        return this.cumulate;
    }

    protected void update() {
        if (this.hasParent()) {
            this.cumulate.set(this.parent.getCumulateMatrix());
            this.absoluteTranslation.set(this.parent.getAbsoluteTranslation());
            this.absoluteRotation.set(this.parent.getAbsoluteRotation());
            this.absoluteScaling.set(this.parent.getAbsoluteScaling());
        } else {
            this.cumulate.setIdentity();
            this.absoluteTranslation.setIdentity();
            this.absoluteRotation.setIdentity();
            this.absoluteScaling.setIdentity();
        }
        this.cumulate.mul(this.relativeTranslation);
        this.cumulate.mul(this.relativeRotation);
        this.cumulate.mul(this.relativeScaling);
        this.absoluteTranslation.mul(this.relativeTranslation);
        this.absoluteRotation.mul(this.relativeRotation);
        this.absoluteScaling.mul(this.relativeScaling);
    }

    public Matrix4f getAbsoluteTranslation() {
        return this.absoluteTranslation;
    }

    public Matrix4f getAbsoluteRotation() {
        return this.absoluteRotation;
    }

    public Matrix4f getAbsoluteScaling() {
        return this.absoluteScaling;
    }

    public Matrix4f getRelativeTranslation() {
        return this.relativeTranslation;
    }

    public void setRelativeTranslation(Matrix4f matrix4f) {
        this.relativeTranslation.set(matrix4f);
        this.update();
    }

    public void setRelativeTranslation(Vector3f vector3f) {
        this.relativeTranslation.set(vector3f);
        this.update();
    }

    public Matrix4f getRelativeRotation() {
        return this.relativeRotation;
    }

    public void setRelativeRotation(Matrix4f matrix4f) {
        this.relativeRotation.set(matrix4f);
        this.update();
    }

    public void setRelativeRotation(Matrix3f matrix3f) {
        this.relativeRotation.set(matrix3f);
        this.update();
    }

    public Matrix4f getRelativeScaling() {
        return this.relativeScaling;
    }

    public void setRelativeScaling(Matrix4f matrix4f) {
        this.relativeScaling.set(matrix4f);
        this.update();
    }

    public void setRelativeScaling(Matrix3f matrix3f) {
        this.relativeScaling.set(matrix3f);
        this.update();
    }

    public void setRelativeScaling(Vector3f vector3f) {
        this.relativeScaling.setIdentity();
        this.relativeScaling.m00 = vector3f.x;
        this.relativeScaling.m11 = vector3f.y;
        this.relativeScaling.m22 = vector3f.z;
        this.update();
    }

    public void setRelativeScaling(float f) {
        this.relativeScaling.setIdentity();
        this.relativeScaling.m00 = f;
        this.relativeScaling.m11 = f;
        this.relativeScaling.m22 = f;
        this.update();
    }

    public void setRelatives(Matrix4f matrix4f, Matrix4f matrix4f2, Matrix4f matrix4f3) {
        if (matrix4f != null) {
            this.relativeTranslation.set(matrix4f);
        }
        if (matrix4f2 != null) {
            this.relativeRotation.set(matrix4f2);
        }
        if (matrix4f3 != null) {
            this.relativeScaling.set(matrix4f3);
        }
        this.update();
    }

    public boolean equals(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            return node.id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public String toString() {
        return this.getName();
    }
}

