/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.scene.camera;

import de.ti2010.mars.scene.Camera;
import de.ti2010.mars.scene.camera.CameraManagerListener;
import de.ti2010.mars.scene.camera.DefaultCamera;
import java.util.ArrayList;
import java.util.List;

public class CameraManager {
    private List<CameraManagerListener> listener = new ArrayList<CameraManagerListener>();
    private Camera aktiveCamera = null;

    public void addCameraManagerListener(CameraManagerListener cameraManagerListener) {
        this.listener.add(cameraManagerListener);
    }

    public void removeCameraManagerListener(CameraManagerListener cameraManagerListener) {
        this.listener.remove(cameraManagerListener);
    }

    public void activate(Camera camera) {
        if (this.aktiveCamera != null) {
            this.aktiveCamera.setActive(false);
        }
        this.aktiveCamera = camera;
        for (CameraManagerListener cameraManagerListener : this.listener) {
            cameraManagerListener.cameraActivated(camera);
        }
    }

    public void deactivate(Camera camera) {
        for (CameraManagerListener cameraManagerListener : this.listener) {
            cameraManagerListener.cameraDeactivated(camera);
        }
    }

    public Camera createCamera() {
        return new DefaultCamera(this);
    }
}

