/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.scene.camera;

import de.ti2010.mars.scene.Camera;
import de.ti2010.mars.scene.camera.CameraManager;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;

public class DefaultCamera
implements Camera {
    private boolean active = false;
    private CameraManager camManager;
    private Vector3f position = new Vector3f();
    private Vector3f cameraOffset = new Vector3f();
    private boolean invertX = true;
    private boolean invertY = true;
    private boolean invertZ = true;
    private float yaw = 0.0f;
    private float pitch = 0.0f;
    private float roll = 0.0f;
    private float yawOffset = 0.0f;
    private float pitchOffset = 0.0f;
    private float rollOffset = 0.0f;
    private boolean noYawLimit = true;
    private boolean noPitchLimit = true;
    private boolean noRollLimit = true;
    private float minYaw = 0.0f;
    private float minPitch = 0.0f;
    private float maxYaw = 0.0f;
    private float maxPitch = 0.0f;
    private float minRoll = 0.0f;
    private float maxRoll = 0.0f;
    private float distance = 0.0f;
    private float minDistance = 0.0f;
    private float maxDistance = 0.0f;
    private float distanceChange = 0.0f;
    private float mouseSensitivity = 0.0f;
    private Matrix4f rotXMatrix = new Matrix4f();
    private Matrix4f rotYMatrix = new Matrix4f();
    private Matrix4f rotZMatrix = new Matrix4f();
    private Matrix4f translationMatrix = new Matrix4f();
    private Matrix4f viewMatrix = new Matrix4f();

    private void init() {
        this.distanceChange = 1.1f;
        this.mouseSensitivity = 0.0025f;
    }

    public DefaultCamera(CameraManager cameraManager) {
        this.camManager = cameraManager;
        this.init();
    }

    @Override
    public boolean isInvertZ() {
        return this.invertZ;
    }

    @Override
    public boolean isInvertX() {
        return this.invertX;
    }

    @Override
    public boolean isInvertY() {
        return this.invertY;
    }

    @Override
    public void setInvertZ(boolean bl) {
        this.invertZ = bl;
    }

    @Override
    public void setInvertX(boolean bl) {
        this.invertX = bl;
    }

    @Override
    public void setInvertY(boolean bl) {
        this.invertY = bl;
    }

    @Override
    public Vector3f getPosition() {
        Vector3f vector3f = new Vector3f(this.position.x + this.cameraOffset.x, this.position.y + this.cameraOffset.y, this.position.z + this.cameraOffset.z);
        if (this.invertX) {
            vector3f.x = -vector3f.x;
        }
        if (this.invertY) {
            vector3f.y = -vector3f.y;
        }
        if (this.invertZ) {
            vector3f.z = -vector3f.z;
        }
        return vector3f;
    }

    @Override
    public void setPosition(Vector3f vector3f) {
        this.position = vector3f;
    }

    @Override
    public void setX(float f) {
        this.position.x = f;
    }

    @Override
    public float getX() {
        return this.position.x;
    }

    @Override
    public void setY(float f) {
        this.position.y = f;
    }

    @Override
    public float getY() {
        return this.position.y;
    }

    @Override
    public void setZ(float f) {
        this.position.z = f;
    }

    @Override
    public float getZ() {
        return this.position.z;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public void setYaw(float f) {
        this.yaw = this.noYawLimit ? f : Math.min(Math.max(f, this.minYaw + this.yawOffset), this.maxYaw + this.yawOffset);
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    @Override
    public void setPitch(float f) {
        this.pitch = this.noPitchLimit ? f : Math.min(Math.max(f, this.minPitch + this.pitchOffset), this.maxPitch + this.pitchOffset);
    }

    @Override
    public float getRoll() {
        return this.roll;
    }

    @Override
    public void setRoll(float f) {
        this.roll = this.noRollLimit ? f : Math.min(Math.max(f, this.minRoll + this.rollOffset), this.maxRoll + this.rollOffset);
    }

    @Override
    public float getYawOffset() {
        return this.yawOffset;
    }

    @Override
    public void setYawOffset(float f) {
        this.setYaw(f);
        this.yawOffset = f;
    }

    @Override
    public float getPitchOffset() {
        return this.pitchOffset;
    }

    @Override
    public void setPitchOffset(float f) {
        this.setPitch(f);
        this.pitchOffset = f;
    }

    @Override
    public float getRollOffset() {
        return this.rollOffset;
    }

    @Override
    public void setRollOffset(float f) {
        this.setRoll(f);
        this.rollOffset = f;
    }

    @Override
    public Vector3f getCameraOffset() {
        return this.cameraOffset;
    }

    @Override
    public void setCameraOffset(Vector3f vector3f) {
        this.cameraOffset = vector3f;
    }

    @Override
    public boolean isNoYawLimit() {
        return this.noYawLimit;
    }

    @Override
    public void setNoYawLimit(boolean bl) {
        this.noYawLimit = bl;
    }

    @Override
    public boolean isNoPitchLimit() {
        return this.noPitchLimit;
    }

    @Override
    public void setNoPitchLimit(boolean bl) {
        this.noPitchLimit = bl;
    }

    @Override
    public boolean isNoRollLimit() {
        return this.noRollLimit;
    }

    @Override
    public void setNoRollLimit(boolean bl) {
        this.noRollLimit = bl;
    }

    @Override
    public float getMinYaw() {
        return this.minYaw;
    }

    @Override
    public void setMinYaw(float f) {
        this.setNoYawLimit(false);
        this.minYaw = f;
    }

    @Override
    public float getMinPitch() {
        return this.minPitch;
    }

    @Override
    public void setMinPitch(float f) {
        this.setNoPitchLimit(false);
        this.minPitch = f;
    }

    @Override
    public float getMaxYaw() {
        return this.maxYaw;
    }

    @Override
    public void setMaxYaw(float f) {
        this.setNoYawLimit(false);
        this.maxYaw = f;
    }

    @Override
    public float getMaxPitch() {
        return this.maxPitch;
    }

    @Override
    public float getMinRoll() {
        return this.minRoll;
    }

    @Override
    public void setMinRoll(float f) {
        this.setNoPitchLimit(false);
        this.minRoll = f;
    }

    @Override
    public float getMaxRoll() {
        return this.maxRoll;
    }

    @Override
    public void setMaxRoll(float f) {
        this.setNoPitchLimit(false);
        this.maxRoll = f;
    }

    @Override
    public void setMaxPitch(float f) {
        this.setNoPitchLimit(false);
        this.maxPitch = f;
    }

    @Override
    public float getDistance() {
        return this.distance;
    }

    @Override
    public void setDistance(float f) {
        this.distance = Math.min(Math.max(f, this.minDistance), this.maxDistance);
    }

    @Override
    public float getDistanceChange() {
        return this.distanceChange;
    }

    @Override
    public void setDistanceChange(float f) {
        this.distanceChange = f;
    }

    @Override
    public float getMinDistance() {
        return this.minDistance;
    }

    @Override
    public void setMinDistance(float f) {
        this.minDistance = f;
    }

    @Override
    public float getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public void setMaxDistance(float f) {
        this.maxDistance = f;
    }

    @Override
    public void increaseDistance() {
        this.setDistance(this.getDistance() * this.distanceChange);
    }

    @Override
    public void decreaseDistance() {
        this.setDistance(this.getDistance() / this.distanceChange);
    }

    @Override
    public float getMouseSensitivity() {
        return this.mouseSensitivity;
    }

    @Override
    public void setMouseSensitivity(float f) {
        this.mouseSensitivity = f;
    }

    @Override
    public Matrix4f getViewMatrix() {
        this.rotXMatrix.setIdentity();
        this.rotYMatrix.setIdentity();
        this.translationMatrix.setIdentity();
        this.rotXMatrix.setTranslation(new Vector3f(0.0f, 0.0f, this.getDistance()));
        this.rotXMatrix.rotX(this.getPitch());
        this.rotXMatrix.setTranslation(new Vector3f(0.0f, 0.0f, -this.getDistance()));
        this.rotYMatrix.rotY(this.getYaw());
        this.rotZMatrix.rotZ(this.getRoll());
        this.translationMatrix.setTranslation(this.getPosition());
        this.rotYMatrix.mul(this.rotZMatrix);
        this.rotXMatrix.mul(this.rotYMatrix);
        this.viewMatrix.mul(this.rotXMatrix, this.translationMatrix);
        return this.viewMatrix;
    }

    @Override
    public CameraManager getCameraManager() {
        return this.camManager;
    }

    @Override
    public void setActive(boolean bl) {
        if (bl) {
            this.active = true;
            this.camManager.activate(this);
        } else {
            this.active = false;
            this.camManager.deactivate(this);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }
}

