/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.simulator;

import de.ti2010.mars.input.KeyEvent;
import de.ti2010.mars.input.MouseEvent;
import de.ti2010.mars.scene.Camera;
import de.ti2010.mars.simulator.Controller;
import javax.vecmath.Vector3f;

public class FreeFlyController
implements Controller {
    private float movingSpeed = 1.0f;
    private final float maxMovingSpeed = 10.0f;
    private final float minMovingSpeed = 0.02f;
    private final float movingSpeedchange = 1.2f;
    private boolean movingForward = false;
    private boolean movingBackward = false;
    private boolean movingLeft = false;
    private boolean movingRight = false;
    private Vector3f position = new Vector3f();
    private Camera camera = null;

    public FreeFlyController(Camera camera) {
        this.camera = camera;
        this.camera.setMinPitch(-1.7707963f);
        this.camera.setMaxPitch(1.3707963f);
        this.resetPosition();
    }

    private void calculateYaw(float f) {
        this.camera.setYaw(this.camera.getYaw() + f);
    }

    private void calculatePitch(float f) {
        this.camera.setPitch(this.camera.getPitch() + f);
    }

    private void moveForward(float f) {
        this.position.x += f * (float)Math.sin(this.camera.getYaw());
        this.position.z -= f * (float)Math.cos(this.camera.getYaw());
        this.position.y -= f * (float)Math.tan(this.camera.getPitch());
    }

    private void moveBackward(float f) {
        this.position.x -= f * (float)Math.sin(this.camera.getYaw());
        this.position.z += f * (float)Math.cos(this.camera.getYaw());
        this.position.y += f * (float)Math.tan(this.camera.getPitch());
    }

    private void strafeLeft(float f) {
        this.position.x += f * (float)Math.sin((double)this.camera.getYaw() - Math.toRadians(90.0));
        this.position.z -= f * (float)Math.cos((double)this.camera.getYaw() - Math.toRadians(90.0));
    }

    private void strafeRight(float f) {
        this.position.x += f * (float)Math.sin((double)this.camera.getYaw() + Math.toRadians(90.0));
        this.position.z -= f * (float)Math.cos((double)this.camera.getYaw() + Math.toRadians(90.0));
    }

    public void resetPosition() {
        this.position = new Vector3f(0.0f, 20.0f, 20.0f);
        this.camera.setPosition(this.position);
        this.camera.setPitch(0.4f);
        this.camera.setYaw(0.0f);
    }

    @Override
    public void handle(MouseEvent mouseEvent) {
        this.calculateYaw((float)mouseEvent.getDeltaX() * this.camera.getMouseSensitivity());
        this.calculatePitch((float)(-mouseEvent.getDeltaY()) * this.camera.getMouseSensitivity());
        if (mouseEvent.getDWheel() > 0 && this.movingSpeed < 10.0f) {
            this.movingSpeed *= 1.2f;
        }
        if (mouseEvent.getDWheel() < 0 && this.movingSpeed > 0.02f) {
            this.movingSpeed /= 1.2f;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKey()) {
            case 17: {
                this.movingForward = true;
                break;
            }
            case 31: {
                this.movingBackward = true;
                break;
            }
            case 30: {
                this.movingLeft = true;
                break;
            }
            case 32: {
                this.movingRight = true;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKey()) {
            case 17: {
                this.movingForward = false;
                break;
            }
            case 31: {
                this.movingBackward = false;
                break;
            }
            case 30: {
                this.movingLeft = false;
                break;
            }
            case 32: {
                this.movingRight = false;
            }
        }
    }

    @Override
    public void update() {
        if (this.movingForward) {
            this.moveForward(this.movingSpeed);
        }
        if (this.movingBackward) {
            this.moveBackward(this.movingSpeed);
        }
        if (this.movingLeft) {
            this.strafeLeft(this.movingSpeed);
        }
        if (this.movingRight) {
            this.strafeRight(this.movingSpeed);
        }
        this.camera.setPosition(this.position);
    }

    @Override
    public void setCameraActive() {
        this.camera.setActive(true);
    }
}

