/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.simulator;

import de.ti2010.mars.ui.HorizontalTextAlign;
import de.ti2010.mars.ui.UILabel;
import de.ti2010.mars.ui.UIPanel;
import de.ti2010.mars.ui.VerticalTextAlign;
import java.awt.Color;

public class HeadUpDisplay
extends UIPanel {
    private UILabel labCamera;
    private UILabel labRoverSpeedText;
    private UILabel labRoverSpeed;
    private UILabel labfpsValue;
    private UILabel labFPS;
    private UILabel labDistance;
    private UILabel labDistanceText;
    private UILabel labWaterVeins;
    private UILabel labWaterVeinsText;
    private UILabel labNumDrills;
    private UILabel labNumDrillsText;
    private double roverSpeed;
    private int fps;
    private float distance;
    private int numDrills;
    private int waterVeins;
    private int maxNumberOfWaterVeins;
    private final int colWidthLeft;
    private final int colWidthRight;
    private final int rowDistance;
    private final String cameraName = "S.N.I.C.K.E.R.S.";
    private Color transpatent = new Color(0.0f, 0.0f, 0.0f, 0.0f);

    public HeadUpDisplay() {
        this.isVisible = false;
        this.roverSpeed = 0.0;
        this.fps = 0;
        this.distance = 0.0f;
        this.numDrills = 0;
        this.waterVeins = 0;
        this.maxNumberOfWaterVeins = 0;
        this.colWidthLeft = 100;
        this.colWidthRight = 60;
        this.rowDistance = 10;
        this.labCamera = new UILabel();
        this.labRoverSpeed = new UILabel();
        this.labRoverSpeedText = new UILabel();
        this.labFPS = new UILabel();
        this.labfpsValue = new UILabel();
        this.labDistanceText = new UILabel();
        this.labDistance = new UILabel();
        this.labNumDrillsText = new UILabel();
        this.labNumDrills = new UILabel();
        this.labWaterVeinsText = new UILabel();
        this.labWaterVeins = new UILabel();
    }

    public void loadHUD() {
        this.labCamera.setLocation(0, 0);
        this.labCamera.setSize(this.colWidthLeft + this.colWidthRight, 30);
        this.labCamera.setText("S.N.I.C.K.E.R.S.");
        this.labCamera.setHorizontalTextAlign(HorizontalTextAlign.Center);
        this.labCamera.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labCamera.setBackground(this.transpatent);
        this.add(this.labCamera);
        this.labRoverSpeedText.setLocation(5, 40);
        this.labRoverSpeedText.setSize(this.colWidthLeft, this.rowDistance);
        this.labRoverSpeedText.setText("km/h: ");
        this.labRoverSpeedText.setHorizontalTextAlign(HorizontalTextAlign.Left);
        this.labRoverSpeedText.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labRoverSpeedText.setBackground(this.transpatent);
        this.add(this.labRoverSpeedText);
        this.labRoverSpeed.setLocation(this.colWidthLeft, 40);
        this.labRoverSpeed.setSize(this.colWidthRight, this.rowDistance);
        this.labRoverSpeed.setText("" + Math.abs(Math.round(this.roverSpeed)));
        this.labRoverSpeed.setHorizontalTextAlign(HorizontalTextAlign.Left);
        this.labRoverSpeed.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labRoverSpeed.setBackground(this.transpatent);
        this.add(this.labRoverSpeed);
        this.labFPS.setLocation(5, 55);
        this.labFPS.setSize(this.colWidthLeft, this.rowDistance);
        this.labFPS.setText("FPS: ");
        this.labFPS.setHorizontalTextAlign(HorizontalTextAlign.Left);
        this.labFPS.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labFPS.setBackground(this.transpatent);
        this.add(this.labFPS);
        this.labfpsValue.setLocation(this.colWidthLeft, 55);
        this.labfpsValue.setSize(this.colWidthRight, this.rowDistance);
        this.labfpsValue.setText("" + this.fps);
        this.labfpsValue.setHorizontalTextAlign(HorizontalTextAlign.Left);
        this.labfpsValue.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labfpsValue.setBackground(this.transpatent);
        this.add(this.labfpsValue);
        this.labDistanceText.setLocation(5, 70);
        this.labDistanceText.setSize(this.colWidthLeft, this.rowDistance);
        this.labDistanceText.setText("Driven km: ");
        this.labDistanceText.setHorizontalTextAlign(HorizontalTextAlign.Left);
        this.labDistanceText.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labDistanceText.setBackground(this.transpatent);
        this.add(this.labDistanceText);
        this.labDistance.setLocation(this.colWidthLeft, 70);
        this.labDistance.setSize(this.colWidthRight, this.rowDistance);
        this.labDistance.setText("" + (double)Math.round(this.getDistance() * 10.0f) / 10.0);
        this.labDistance.setHorizontalTextAlign(HorizontalTextAlign.Left);
        this.labDistance.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labDistance.setBackground(this.transpatent);
        this.add(this.labDistance);
        this.labNumDrillsText.setLocation(5, 85);
        this.labNumDrillsText.setSize(this.colWidthLeft, this.rowDistance);
        this.labNumDrillsText.setText("Drills: ");
        this.labNumDrillsText.setHorizontalTextAlign(HorizontalTextAlign.Left);
        this.labNumDrillsText.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labNumDrillsText.setBackground(this.transpatent);
        this.add(this.labNumDrillsText);
        this.labNumDrills.setLocation(this.colWidthLeft, 85);
        this.labNumDrills.setSize(this.colWidthRight, this.rowDistance);
        this.labNumDrills.setText("" + this.getNumDrills());
        this.labNumDrills.setHorizontalTextAlign(HorizontalTextAlign.Left);
        this.labNumDrills.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labNumDrills.setBackground(this.transpatent);
        this.add(this.labNumDrills);
        this.labWaterVeinsText.setLocation(5, 100);
        this.labWaterVeinsText.setSize(this.colWidthLeft, this.rowDistance);
        this.labWaterVeinsText.setText("Water Veins:");
        this.labWaterVeinsText.setHorizontalTextAlign(HorizontalTextAlign.Left);
        this.labWaterVeinsText.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labWaterVeinsText.setBackground(this.transpatent);
        this.add(this.labWaterVeinsText);
        this.labWaterVeins.setLocation(this.colWidthLeft, 100);
        this.labWaterVeins.setSize(this.colWidthRight, this.rowDistance);
        this.labWaterVeins.setText(this.getWaterVeins() + "/10");
        this.labWaterVeins.setHorizontalTextAlign(HorizontalTextAlign.Left);
        this.labWaterVeins.setVerticalTextAlign(VerticalTextAlign.Middle);
        this.labWaterVeins.setBackground(this.transpatent);
        this.add(this.labWaterVeins);
    }

    public void updateHUD() {
        if (Math.abs(this.roverSpeed) < 1.4) {
            this.roverSpeed = 0.0;
        }
        this.labRoverSpeed.setText("" + Math.abs(Math.round(this.getRoverSpeed())));
        this.labfpsValue.setText("" + this.fps);
        this.labDistance.setText("" + (double)Math.round(this.getDistance() * 10.0f) / 10.0);
        this.labNumDrills.setText("" + this.getNumDrills());
        this.labWaterVeins.setText(this.getWaterVeins() + "/" + this.getMaxNumberOfWaterVeins());
    }

    public double getRoverSpeed() {
        return this.roverSpeed;
    }

    public void setRoverSpeed(double d) {
        this.roverSpeed = d;
    }

    public int getFps() {
        return this.fps;
    }

    public void setFps(int n) {
        this.fps = n;
    }

    public float getDistance() {
        return this.distance;
    }

    public void setDistance(float f) {
        this.distance = f;
    }

    public int getNumDrills() {
        return this.numDrills;
    }

    public void setNumDrills(int n) {
        this.numDrills = n;
    }

    public int getWaterVeins() {
        return this.waterVeins;
    }

    public void setWaterVeins(int n) {
        this.waterVeins = n;
    }

    public int getMaxNumberOfWaterVeins() {
        return this.maxNumberOfWaterVeins;
    }

    public void setMaxNumberOfWaterVeins(int n) {
        this.maxNumberOfWaterVeins = n;
    }
}

