/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.simulator;

import de.ti2010.mars.gfx.core.NativeUIFrame;
import de.ti2010.mars.gfx.core.impl.NativeUIFrameImpl;
import de.ti2010.mars.gfx.gl.GL;
import de.ti2010.mars.gfx.renderer.RenderConfiguration;
import de.ti2010.mars.gfx.renderer.SceneRenderer;
import de.ti2010.mars.gfx.renderer.UIRenderer;
import de.ti2010.mars.gfx.renderer.impl.RendererFactory;
import de.ti2010.mars.input.GeneralKeyboardInput;
import de.ti2010.mars.input.KeyboardInput;
import de.ti2010.mars.input.MouseInput;
import de.ti2010.mars.physics.jbullet.JBulletAbstractBasicElementRepresentation;
import de.ti2010.mars.physics.jbullet.JBulletWorld;
import de.ti2010.mars.scene.Camera;
import de.ti2010.mars.scene.CameraNode;
import de.ti2010.mars.scene.GroupNode;
import de.ti2010.mars.scene.Scene;
import de.ti2010.mars.scene.camera.CameraManager;
import de.ti2010.mars.scene.camera.CameraManagerListener;
import de.ti2010.mars.simulator.Controller;
import de.ti2010.mars.simulator.ControllerManager;
import de.ti2010.mars.simulator.FreeFlyController;
import de.ti2010.mars.simulator.Ground;
import de.ti2010.mars.simulator.HeadUpDisplay;
import de.ti2010.mars.simulator.Menu;
import de.ti2010.mars.simulator.MenuController;
import de.ti2010.mars.simulator.PlayTimeDisplay;
import de.ti2010.mars.simulator.RoverVehicle;
import de.ti2010.mars.simulator.Stone;
import de.ti2010.mars.simulator.Timer;
import de.ti2010.mars.simulator.assets.Skybox;
import de.ti2010.mars.simulator.assets.Sun;
import de.ti2010.mars.ui.UIFrame;
import javax.vecmath.Vector3f;
import org.apache.log4j.xml.DOMConfigurator;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.PixelFormat;

public class Simulator
implements CameraManagerListener {
    private Menu menu = new Menu();
    private HeadUpDisplay hud = new HeadUpDisplay();
    private RoverVehicle roverVehicle = null;
    private FreeFlyController freeflycontroller;
    private CameraManager cameraManager;
    private CameraNode frontCamera;
    private CameraNode topCamera;
    private CameraNode backCamera;
    private CameraNode clamshellCamera;
    private Camera menuCamera;
    private MouseInput mouseInput;
    private KeyboardInput keyboardInput;
    private GeneralKeyboardInput generalKeyboardInput;
    private Controller currentController;
    private Controller lastController = null;
    private ControllerManager controllerlist = new ControllerManager();
    private MenuController menuController;
    private Scene scene = null;
    private RenderConfiguration renderConfig = null;
    private SceneRenderer renderer = null;
    private UIRenderer uirenderer = null;
    private JBulletWorld jbw = null;
    private Stone stone = null;
    private final int countStones = 15;
    private Ground ground = null;
    private final float groundXMin = 280.0f;
    private final float groundXMax = 270.0f;
    private final float groundZMin = 200.0f;
    private final float groundZMax = 250.0f;
    private Skybox skybox = new Skybox();
    private Sun sun = new Sun();
    private GL gl;
    private int fps = 0;
    private int countfps = 0;
    private long lastFPS;
    private UIFrame uiFrame = new NativeUIFrameImpl();
    private Timer timer = new Timer();
    private PlayTimeDisplay playTimeDisplay;

    public void start() {
        this.renderConfig = new RenderConfiguration();
        this.initOpenGLContext();
        this.cameraManager = new CameraManager();
        this.cameraManager.addCameraManagerListener(this);
        this.scene = new Scene();
        this.initInputs();
        this.initController();
        this.initBulletPhysics();
        this.loadScene();
        this.loadPlayTime();
        this.loadUI();
        this.initRenderer();
        this.initUIRenderer();
        this.mouseInput.setGrabbed(true);
        this.lastFPS = this.getTime();
        this.timer.start();
        while (!Display.isCloseRequested() && !this.menu.isTerminate()) {
            if (this.menu.isReset()) {
                this.roverVehicle.setPosition(new Vector3f(0.0f, 1.0f, 0.0f));
                this.freeflycontroller.resetPosition();
            }
            this.mouseInput.pollEvents();
            this.keyboardInput.pollEvents();
            if (!this.controllerlist.isEmpty()) {
                if (this.menu.isVisible()) {
                    if (this.lastController == null) {
                        this.switchControllerToMenuController(true);
                        this.timer.pause();
                    }
                } else {
                    if (this.lastController != null) {
                        this.switchControllerToMenuController(false);
                        this.timer.resume();
                    }
                    if (this.generalKeyboardInput.getChangeCamera()) {
                        this.switchController();
                    }
                }
                this.currentController.update();
            }
            if (this.generalKeyboardInput.getSpace()) {
                this.mouseInput.toggleGrabbed();
                this.mouseInput.toogleDisableMouse();
            }
            this.jbw.doStep();
            this.renderer.setMode(this.generalKeyboardInput.getChangeRenderMode());
            this.ground.checkDrillPostition(this.roverVehicle.getLastDrillPosition());
            this.updateFPS();
            this.updateHUD();
            this.renderer.render(this.scene);
            this.uirenderer.render((NativeUIFrame)((Object)this.uiFrame));
            this.updatePlayTime();
            Display.sync((int)60);
            Display.update();
        }
        Display.destroy();
        this.terminate();
    }

    private void terminate() {
        ((NativeUIFrame)((Object)this.uiFrame)).free();
    }

    private void initOpenGLContext() {
        this.gl = GL.instantiate(1);
        try {
            PixelFormat pixelFormat = new PixelFormat();
            ContextAttribs contextAttribs = new ContextAttribs(3, 2).withProfileCore(true);
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.renderConfig.getDisplayWidth(), this.renderConfig.getDisplayHeight()));
            Display.setTitle((String)"M.A.R.S. - Mars And Rover Simulator");
            Display.create((PixelFormat)pixelFormat, (ContextAttribs)contextAttribs);
            this.gl.glClearColor(0.3f, 0.3f, 0.3f, 0.0f);
            this.gl.glViewport(0, 0, this.renderConfig.getDisplayWidth(), this.renderConfig.getDisplayHeight());
            this.gl.glEnable(2929);
            this.gl.glDepthMask(true);
            this.gl.glDepthFunc(515);
            this.gl.glBlendFunc(770, 771);
            this.gl.glClearDepth(this.renderConfig.getFarPlane());
            this.gl.glEnable(2884);
            Display.setVSyncEnabled((boolean)true);
            System.out.println("OS name " + System.getProperty("os.name"));
            System.out.println("OS version " + System.getProperty("os.version"));
            System.out.println("LWJGL version " + Sys.getVersion());
            System.out.println("OpenGL version " + this.gl.glGetString(7938));
            System.out.println("Graphic Vendor " + this.gl.glGetString(7936));
        }
        catch (LWJGLException lWJGLException) {
            System.out.println("Fail in function setupOpenGL() of class Simulator. The program will be terminated.");
            lWJGLException.printStackTrace();
            System.exit(-1);
        }
    }

    private void initBulletPhysics() {
        this.jbw = new JBulletWorld();
    }

    private void initRenderer() {
        this.renderer = RendererFactory.getInstance().createSceneRenderer(this.renderConfig);
        this.renderer.initialize(this.renderConfig);
    }

    private void initUIRenderer() {
        this.uirenderer = RendererFactory.getInstance().createUIRenderer(this.renderConfig);
        this.uirenderer.initialize(this.renderConfig);
    }

    private void loadUI() {
        ((NativeUIFrame)((Object)this.uiFrame)).initialize(0, 0, this.renderConfig.getDisplayWidth(), this.renderConfig.getDisplayHeight());
        this.menu.setSize(this.renderConfig.getDisplayWidth(), 700);
        int n = 0;
        int n2 = (this.uiFrame.getHeight() - this.menu.getHeight()) / 2;
        this.menu.setLocation(n, n2);
        this.uiFrame.add(this.menu);
        n = (this.uiFrame.getWidth() - this.playTimeDisplay.getWidth()) / 2;
        this.playTimeDisplay.setLocation(n, 10);
        this.uiFrame.add(this.playTimeDisplay);
        this.hud.setSize(160, 120);
        this.hud.setLocation(0, 0);
        this.hud.loadHUD();
        this.hud.setMaxNumberOfWaterVeins(this.ground.getNumberOfWater());
        this.uiFrame.add(this.hud);
    }

    private void loadPlayTime() {
        this.playTimeDisplay = new PlayTimeDisplay();
        this.playTimeDisplay.setPlayTime(0);
    }

    private void loadScene() {
        GroupNode groupNode = new GroupNode();
        this.scene.setRoot(groupNode);
        groupNode.add(this.roverVehicle.buildRoverNode(this.jbw));
        for (int i = 0; i < 15; ++i) {
            this.stone = new Stone();
            groupNode.add(this.stone.buildStone());
            this.jbw.addJBulletAbstractBasicElementRepresentation((JBulletAbstractBasicElementRepresentation)((Object)this.stone.getPhysicalElement()));
            this.stone.setPosition(new Vector3f((float)(Math.random() * 550.0 - 280.0), 20.0f, (float)(Math.random() * 450.0 - 200.0)));
        }
        this.ground = new Ground();
        groupNode.add(this.ground.buildGround());
        this.jbw.addJBulletAbstractBasicElementRepresentation((JBulletAbstractBasicElementRepresentation)((Object)this.ground.getPhysicalElement()));
        groupNode.add(this.skybox.buildSky());
        groupNode.add(this.sun.buildsun());
    }

    private void initInputs() {
        this.mouseInput = new MouseInput();
        this.keyboardInput = new KeyboardInput();
        this.generalKeyboardInput = new GeneralKeyboardInput();
        this.keyboardInput.addController(this.generalKeyboardInput);
        this.keyboardInput.addController(this.menu);
        this.keyboardInput.addController(this.sun);
    }

    private void initController() {
        Camera camera = this.cameraManager.createCamera();
        this.freeflycontroller = new FreeFlyController(camera);
        this.frontCamera = new CameraNode(this.cameraManager.createCamera(), CameraNode.Type.MountedCamera);
        this.topCamera = new CameraNode(this.cameraManager.createCamera(), CameraNode.Type.FollowerCamera);
        this.backCamera = new CameraNode(this.cameraManager.createCamera(), CameraNode.Type.MountedCamera);
        this.clamshellCamera = new CameraNode(this.cameraManager.createCamera(), CameraNode.Type.MountedCamera);
        this.menuCamera = new CameraNode(this.cameraManager.createCamera(), CameraNode.Type.FollowerCamera);
        this.menuController = new MenuController(this.menuCamera);
        this.roverVehicle = new RoverVehicle(this.frontCamera, this.topCamera, this.backCamera, this.clamshellCamera, this.menuCamera);
        this.controllerlist.add(this.roverVehicle);
        this.controllerlist.add(this.freeflycontroller);
        if (this.controllerlist.isEmpty()) {
            System.err.println("Es wurde kein Controller hinzugefuegt!");
        } else {
            this.currentController = this.controllerlist.next();
            this.currentController.setCameraActive();
            this.mouseInput.addController(this.currentController);
            this.keyboardInput.addController(this.currentController);
        }
    }

    private void switchController() {
        if (!this.controllerlist.isEmpty()) {
            this.mouseInput.removeController(this.currentController);
            this.keyboardInput.removeController(this.currentController);
            this.currentController = this.controllerlist.next();
            this.currentController.setCameraActive();
            this.mouseInput.addController(this.currentController);
            this.keyboardInput.addController(this.currentController);
            if (this.currentController == this.roverVehicle) {
                this.hud.setVisible(true);
            } else {
                this.hud.setVisible(false);
            }
        }
    }

    private void switchControllerToMenuController(boolean bl) {
        if (bl) {
            this.mouseInput.removeController(this.currentController);
            this.keyboardInput.removeController(this.currentController);
            this.lastController = this.currentController;
            this.currentController = this.menuController;
            this.currentController.setCameraActive();
            this.mouseInput.addController(this.currentController);
            this.keyboardInput.addController(this.currentController);
        } else {
            this.mouseInput.removeController(this.currentController);
            this.keyboardInput.removeController(this.currentController);
            this.currentController = this.lastController;
            this.lastController = null;
            this.currentController.setCameraActive();
            this.mouseInput.addController(this.currentController);
            this.keyboardInput.addController(this.currentController);
            if (this.currentController == this.roverVehicle) {
                this.hud.setVisible(true);
            }
        }
    }

    public void updateFPS() {
        if (this.getTime() - this.lastFPS > 1000L) {
            this.fps = this.countfps;
            this.countfps = 0;
            this.lastFPS += 1000L;
        }
        ++this.countfps;
    }

    public void updateHUD() {
        if (!this.menu.isVisible()) {
            this.hud.setDistance(this.roverVehicle.getDrivenDistance());
            this.hud.setNumDrills(this.roverVehicle.getNumDrills());
            this.hud.setFps(this.fps);
            this.hud.setRoverSpeed(this.roverVehicle.getCurrentSpeedKmHour());
            this.hud.setWaterVeins(this.ground.getFoundWaterVeins());
            this.hud.updateHUD();
        } else {
            this.hud.setVisible(false);
        }
    }

    public void updatePlayTime() {
        if (!this.menu.isVisible()) {
            this.playTimeDisplay.setVisible(true);
            this.playTimeDisplay.setPlayTime((int)this.timer.getTime());
        } else {
            this.playTimeDisplay.setVisible(false);
        }
    }

    public long getTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    @Override
    public void cameraActivated(Camera camera) {
        this.scene.setCamera(camera);
    }

    @Override
    public void cameraDeactivated(Camera camera) {
    }

    public static void main(String[] stringArray) {
        DOMConfigurator.configureAndWatch((String)"res/log4j.xml", (long)60000L);
        String string = System.getProperty("os.name");
        if (string.contains("Mac")) {
            string = "macosx";
        } else if (string.contains("Windows")) {
            string = "windows";
        } else if (string.contains("Linux")) {
            string = "linux";
        } else if (string.contains("Solaris")) {
            string = "solaris";
        }
        System.setProperty("org.lwjgl.librarypath", System.getProperty("user.dir") + "/lib/natives/" + string);
        new Simulator().start();
    }
}

