/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.simulator;

import org.lwjgl.Sys;

public class Timer {
    private long time = 0L;
    private long startTime = 0L;
    private long stopTime = 0L;
    private long pauseTime = 0L;

    public long getTime() {
        if (this.stopTime != 0L) {
            this.time = this.stopTime - this.startTime;
            if (this.pauseTime != 0L) {
                this.time -= this.stopTime - this.pauseTime;
            }
        } else {
            this.time = this.getSystemTime() - this.startTime;
            if (this.pauseTime != 0L) {
                this.time -= this.getSystemTime() - this.pauseTime;
            }
        }
        return this.time / 1000L;
    }

    private long getSystemTime() {
        return Sys.getTime() * 1000L / Sys.getTimerResolution();
    }

    public void start() {
        this.startTime = this.getSystemTime();
    }

    public void stop() {
        this.stopTime = this.getSystemTime();
    }

    public void pause() {
        this.pauseTime = this.getSystemTime();
    }

    public void resume() {
        this.pauseTime = this.getSystemTime() - this.pauseTime;
        this.startTime += this.pauseTime;
        this.pauseTime = 0L;
    }
}

