/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;

public abstract class UIComponent {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Color background = new Color(0.5f, 0.5f, 0.5f, 0.5f);
    protected Color foreground = Color.WHITE;
    protected UIComponent parent;
    protected List<UIComponent> components = new ArrayList<UIComponent>();
    protected boolean isVisible = true;

    public void add(UIComponent uIComponent) {
        if (uIComponent == null) {
            return;
        }
        if (uIComponent.parent != null) {
            uIComponent.parent.remove(uIComponent);
        }
        this.components.add(uIComponent);
        uIComponent.parent = this;
    }

    public void remove(UIComponent uIComponent) {
        if (uIComponent == null) {
            return;
        }
        this.components.remove(uIComponent);
        uIComponent.parent = null;
    }

    public UIComponent getParent() {
        return this.parent;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public void setLocation(int n, int n2) {
        this.setX(n);
        this.setY(n2);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setSize(int n, int n2) {
        this.setWidth(n);
        this.setHeight(n2);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public UIComponent getComponent(int n) {
        return this.components.get(n);
    }

    public List<UIComponent> getComponents() {
        return this.components;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public abstract void paint(Graphics var1);
}

