/*
 * Decompiled with CFR 0.152.
 */
package de.ti2010.mars.util;

import de.ti2010.mars.util.Observable;
import de.ti2010.mars.util.Observer;
import java.util.ArrayList;
import java.util.List;

public class DefaultObservable<T>
implements Observable<T> {
    private Observable<T> delegate;
    private List<Observer<T>> observers;

    public DefaultObservable() {
        this(null);
    }

    public DefaultObservable(Observable<T> defaultObservable) {
        if (defaultObservable == null) {
            defaultObservable = this;
        }
        this.delegate = defaultObservable;
        this.observers = new ArrayList<Observer<T>>();
    }

    @Override
    public void add(Observer<T> observer) {
        this.observers.add(observer);
    }

    @Override
    public void remove(Observer<T> observer) {
        this.observers.remove(observer);
    }

    @Override
    public void notifyObservers(T t) {
        for (Observer<T> observer : this.observers) {
            observer.update(this.delegate, t);
        }
    }
}

