/**
 * Je Frame wird für jedes Vertex der Vertexshader einmal ausgeführt. 
 * Der Shader hat dabei nur Zugriff auf den gerade behandelten Vertex
 * (inkl. seiner Texturkoordinaten, Normalen und sonstiger übergebener Daten), 
 * aber nicht etwa auf Nachbar-Vertices, die Topologie oder Ähnliches.
 * 
 * @author Elmar Schug, Andreas Huber
 * @since 04.10.2012
 *
 */

#version 150 core

uniform mat4 projectionMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelMatrix;

in vec4 in_position;
in vec4 in_normal;
in vec2 in_index;
in vec4 in_color;
in vec2 in_texturcoordinate;

out vec4 pass_color;

void main(void)
{
	gl_Position = projectionMatrix * viewMatrix * modelMatrix * in_position;

	pass_color = in_color;
}